package org.zeyda.clawcircus.utils;

import org.zeyda.clawcircus.Data.ClawZ.LibraryMetaFile;

import org.zeyda.clawcircus.Data.Simulink.MdlBlock;

import java.io.*;

/* It's not yet a good solution to abort program execution if an IOException
 * occurs, revise at some point. */

public class FileUtils {
   public static String readTextFile(String filename) {
      StringBuilder text = new StringBuilder();
      try {
         FileReader reader = new FileReader(filename);
         int c;
         while ((c = reader.read()) != -1) {
            text.append((char) c);
         }
         reader.close();
      }
      catch(FileNotFoundException e) {
         System.out.println("File not found: " + filename);
         System.exit(-1);
      }
      catch(IOException e) {
         System.out.println(e.toString());
         System.exit(-1);
      }
      return text.toString();
   }

   public static String readDataFile(String filename) {
      StringBuilder text = new StringBuilder();
      try {
         BufferedInputStream input_stream =
            new BufferedInputStream(new FileInputStream(filename));
         int c;
         while ((c = input_stream.read()) != -1) {
            text.append((char) c);
         }
         input_stream.close();
      }
      catch(FileNotFoundException e) {
         System.out.println("File not found: " + filename);
         System.exit(-1);
      }
      catch(IOException e) {
         System.out.println(e.toString());
         System.exit(-1);
      }
      return text.toString();
   }

   public static void writeTextFile(String filename, String text) {
      try {
         FileWriter writer = new FileWriter(filename);
         writer.write(text);
         writer.close();
      }
      catch(IOException e) {
         System.out.println(e.toString());
         System.exit(-1);
      }
   }

   public static void writeDataFile(String filename, String text) {
      try {
         BufferedOutputStream output_stream =
            new BufferedOutputStream(new FileOutputStream(filename));
         for(int index = 0; index < text.length(); index++) {
            output_stream.write(text.charAt(index));
         }
         output_stream.close();
      }
      catch(IOException e) {
         System.out.println(e.toString());
         System.exit(-1);
      }
   }

   public static MdlBlock readMdl(String filename) {
      /*String text = readDataFile(filename);*/
      String text = readTextFile(filename);
      MdlBlock model = ParserUtils.parseMdl(text);
      return model;
   }

   public static void writeMdl(String filename, MdlBlock model) {
      /* Need a newline here for Simulink not to grumble. */
      /*writeDataFile(filename, model.serialise() + "\n");*/
      writeTextFile(filename, model.serialise() + "\n");
   }

   public static LibraryMetaFile readLmf(String filename) {
      String text = readDataFile(filename);
      LibraryMetaFile lmf = ParserUtils.parseLmf(text);
      return lmf;
   }

   public static void writeLmf(String filename, LibraryMetaFile lmf) {
      writeDataFile(filename, lmf.serialise() + "\n");
   }
}
