package org.zeyda.clawcircus.utils;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.Data.Diagram.Link;

import org.zeyda.clawcircus.collections.*;
import org.zeyda.clawcircus.collections.impl.*;

import java.util.Iterator;

public class DiagramUtils {
   public static Link connect(Port src_port, Port dst_port) {
      assert src_port.isValid();
      assert src_port.isOutput();
      assert dst_port.isValid();
      assert dst_port.isInput();
      assert !dst_port.isConnected();
      Link link;
      if (src_port.isConnected()) {
         link = src_port.getLink();
      }
      else {
         link = new Link(src_port);
      }
      link.attachToPort(dst_port);
      return link;
   }

   public static LinkSet getInnerLinks(SubSystem subsystem) {
      LinkSet result = subsystem.getInternalLinks();
      for(Iterator<Link> iter = result.iterator(); iter.hasNext(); ) {
         if (iter.next().getSrcBlock().isPort()) {
            iter.remove();
         }
      }
      return result;
   }

   /* Note that the top-level block is also probed for inclusion. */

   public static BlockList getSubordinateBlocksWithState(Block block) {
      BlockList result = new BlockListImpl();
      if (block.getProperty("state", Boolean.class)) {
         result.add(block);
      }
      if (block.isSubSystem()) {
         for(Block child : ((SubSystem) block).getBlocks()) {
            result.addAll(getSubordinateBlocksWithState(child));
         }
      }
      return result;
   }

   /* Note that the following method operates recursively. */

   public static boolean hasSubordinateBlocksWithState(Block block) {
      if (block.getProperty("state", Boolean.class)) {
         return true;
      }
      if (block.isSubSystem()) {
         for(Block child : block.getChildren()) {
            if (hasSubordinateBlocksWithState(child)) {
               return true;
            }
         }
      }
      return false;
   }
}
