package org.zeyda.clawcircus.utils;

public class ClawZUtils {
   public static String toClawZName(String name) {
      /* Remove all white spaces (includes newlines). */
      name = name.replace(" ", "");
      name = name.replace("\n", "");
      name = name.replace("\r", "");
      name = name.replace("\t", "");
      StringBuilder result = new StringBuilder(name);
      if (result.length() != 0) {
         /* Prefix with 'Z' if name starts with a digit. */
         if (isDigit(result.charAt(0))) {
            result.insert(0, "Z");
         }
         for (int index = 0; index < result.length(); index++) {
            /* Replace punctuation marks with 'z'. */
            if (!isAlphaNum(result.charAt(index))) {
               result.setCharAt(index, 'z');
            }
         }
      }
      return result.toString();
   }

   public static String toClawZNameConst(String name) {
      return toClawZName(name) + "x";
   }

   private static boolean isAlphaNum(char c) {
      return isLetter(c) || isDigit(c) || c == '_';
   }

   private static boolean isLetter(char c) {
      return (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z');
   }

   private static boolean isDigit(char c) {
      return c >= '0' && c <= '9';
   }
}
