package org.zeyda.clawcircus.exceptions;

import org.zeyda.clawcircus.Parser.Token;

public class ParserException extends Exception {
   private Token token;

   public ParserException(String message, Token token) {
      super(message);
      this.token = token;
   }

   public ParserException(String message) {
      this(message, null);
   }

   public Token getToken() {
      return token;
   }

   public String getMessage() {
      String result = "Mdl parsing error";
      if (token != null) {
         result += " at token <" + token + ">, line " + token.getLine();
      }
      result += ": " + super.getMessage() + ".";
      return result;
   }
}
