package org.zeyda.clawcircus.collections.core;

import org.zeyda.clawcircus.utils.StringUtils;

import java.util.Collections;

public class LinkedHashSet<T> extends java.util.LinkedHashSet<T> implements
   Set<T> {
   public boolean addIfNotNull(T e) {
      if (e != null) {
         return add(e);
      }
      else {
         return false;
      }
   }

   public boolean isSubsetOf(java.util.Collection<T> c) {
      return c.containsAll(this);
   }

   public boolean disjoint(java.util.Collection<T> c) {
      return Collections.disjoint(this, c);
   }

   public boolean overlap(java.util.Collection<T> c) {
      return !disjoint(c);
   }

   public T select() {
      for(T element : this) {
         return element;
      }
      return null;
   }

   public @Override String toString() {
      return StringUtils.toString(this);
   }
}
