package org.zeyda.clawcircus.UI;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;

import org.zeyda.clawcircus.Toolbox.TranslationStrategy;

import org.zeyda.clawcircus.utils.StringUtils;

import javax.swing.JTree;

import javax.swing.tree.TreeModel;

import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeExpansionListener;

public class JBlockTree extends JTree {
   public JBlockTree(Block root) {
      super(new BlockTreeModel(root));
      root.setAnnotation(TreeModel.class, getModel());
      addTreeExpansionListener(new BlockTreeExpansionListener());
      root.updateUI();
   }

   public BlockTreeModel getBlockTreeModel() {
      return (BlockTreeModel) super.getModel();
   }

   public Block getRoot() {
      assert getModel().getRoot() instanceof Block;
      return (Block) getModel().getRoot();
   }

   public Block getSelectedBlock() {
      if (!isSelectionEmpty()) {
         return (Block) getSelectionPath().getLastPathComponent();
      }
      return null;
   }

   protected @Override TreeModelListener createTreeModelListener() {
      return new BlockTreeModelListener();
   }

   public @Override String convertValueToText(Object value, boolean selected,
      boolean expanded, boolean leaf, int row, boolean hasFocus) {
      if (value instanceof Block) {
         Block block = (Block) value;
         return StringUtils.escape(block.getName())
            + " (" + block.getBlockType() + ")";
      }
      return
         super.convertValueToText(value, selected, expanded, leaf, row,
            hasFocus);
   }

   /* BlockTreeModelListener is invoked when the underlying data changes and
    * therefore the view of the tree has to be updated accordingly. */

   class BlockTreeModelListener extends JTree.TreeModelHandler {
      public @Override void treeNodesChanged(TreeModelEvent e) {
         Block block = (Block) e.getTreePath().getLastPathComponent();
         if (block.isSubSystem()) {
            /* Conditionals here to avoid potential infinite recursion. */
            if (((SubSystem) block).isCentralised()) {
               if (!isCollapsed(e.getTreePath())) {
                  collapsePath(e.getTreePath());
               }
            }
            if (((SubSystem) block).isParallel()) {
               if (!isExpanded(e.getTreePath())) {
                  expandPath(e.getTreePath());
               }
            }
         }
      }
   }

   /* BlockTreeExpansionListener is invoked when the view of the tree changes
    * due to user interaction. Thus we ensure this change is also reflected
    * in the underlying data. */

   class BlockTreeExpansionListener implements TreeExpansionListener {
      public void treeCollapsed(TreeExpansionEvent event) {
         Block block = (Block) event.getPath().getLastPathComponent();
         if (block instanceof SubSystem) {
            ((SubSystem) block).setTranslationStrategy(
               TranslationStrategy.CENTRALISED);
         }
      }

      public void treeExpanded(TreeExpansionEvent event) {
         Block block = (Block) event.getPath().getLastPathComponent();
         if (block instanceof SubSystem) {
            ((SubSystem) block).setTranslationStrategy(
               TranslationStrategy.PARALLEL);
         }
      }
   }

   public @Override void finalize() {
      getRoot().removeAnnotation(TreeModel.class);
   }
}
