package org.zeyda.clawcircus.Toolbox.st;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.Data.Diagram.PortDir;

import org.zeyda.clawcircus.Data.ClaSP.Signal;

import org.zeyda.clawcircus.utils.LatexUtils;
import org.zeyda.clawcircus.utils.TransUtils;

import java.util.List;
import java.util.LinkedList;
import java.util.Collection;

public class SignalConnector {
   private final Signal signal;
   private final Port port;

   /* I'm not too confident with the constructor taking only a signal. Maybe
    * try and remove at some point. */

   public SignalConnector(Signal signal) {
      assert signal != null;
      this.signal = signal;
      this.port = null;
   }

   public SignalConnector(Signal signal, Port port) {
      assert signal != null;
      assert port != null;
      this.signal = signal;
      this.port = port;
   }

   private boolean hasPort() {
      return port != null;
   }

   /* StringTemplate interface methods. */

   public String getName() {
      return LatexUtils.encode(signal.getName());
   }

   public String getLifted() {
      return LatexUtils.encode(signal.lift().getName());
   }

   public String getVar() {
      assert hasPort();
      return LatexUtils.encode(TransUtils.getVar(port));
   }

   public String getDecovar() {
      assert hasPort();
      return LatexUtils.encode(TransUtils.getDecoVar(port));
   }

   /* Utility methods for creation. */

   public static List<SignalConnector> createList(Collection<Signal> signals)
   {
      assert signals != null;
      List<SignalConnector> result = new LinkedList<SignalConnector>();
      for(Signal signal : signals) {
         /*assert signal != null;*/
         if (signal != null) {
            result.add(new SignalConnector(signal));
         }
         else {
            result.add(null);
         }
      }
      return result;
   }

   public static List<SignalConnector> createList(List<Signal> signals, Block
      block, PortDir port_dir) {
      assert signals != null;
      List<SignalConnector> result = new LinkedList<SignalConnector>();
      int port_num = 1;
      for(Signal signal : signals) {
         /*assert signal != null;*/
         if (signal != null) {
            result.add(new SignalConnector(signal,
               new Port(block, port_num, port_dir)));
         }
         else {
            result.add(null);
         }
         port_num++;
      }
      return result;
   }
}
