package org.zeyda.clawcircus.Toolbox.st;

import org.zeyda.clawcircus.Data.ClaSP.BlockWiring;
import org.zeyda.clawcircus.Data.ClaSP.Flow;
import org.zeyda.clawcircus.Data.ClaSP.Signal;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.Data.Diagram.PortDir;

import org.zeyda.clawcircus.utils.LatexUtils;
import org.zeyda.clawcircus.utils.TransUtils;

import java.util.List;
import java.util.ArrayList;

public class FlowConnector {
   private final BlockWiring block_wiring;
   private final Flow flow;
   private final Block block;

   public FlowConnector(BlockWiring block_wiring, Flow flow, Block block) {
      assert block_wiring != null;
      assert flow != null;
      assert block != null;
      assert block_wiring.getFlows().contains(flow);
      this.block_wiring = block_wiring;
      this.flow = flow;
      this.block = block;
   }

   /* StringTemplate interface methods. */

   public String getName() {
      return LatexUtils.encode(TransUtils.createFlowName(flow));
   }

   public List<SignalConnector> getInputs() {
      List<SignalConnector> result = new ArrayList<SignalConnector>();
      int port_num = 1;
      for(Signal inp : block_wiring.getInps()) {
         /*assert inp != null;*/
         if (inp != null && flow.getRInps().contains(inp)) {
            result.add(new SignalConnector(inp,
               new Port(block, port_num, PortDir.INPUT)));
         }
         port_num++;
      }
      return result;
   }

   public List<SignalConnector> getOutputs() {
      List<SignalConnector> result = new ArrayList<SignalConnector>();
      int port_num = 1;
      for(Signal out : block_wiring.getOuts()) {
         /*assert out != null;*/
         if (out != null && flow.getPOuts().contains(out)) {
            result.add(new SignalConnector(out,
               new Port(block, port_num, PortDir.OUTPUT)));
         }
         port_num++;
      }
      return result;
   }


   public List<SignalConnector> getHide_inputs() {
      List<SignalConnector> result = new ArrayList<SignalConnector>();
      int port_num = 1;
      for(Signal inp : block_wiring.getInps()) {
         /*assert inp != null;*/
         if (inp != null && !flow.getRInps().contains(inp)) {
            result.add(new SignalConnector(inp,
               new Port(block, port_num, PortDir.INPUT)));
         }
         port_num++;
      }
      return result;
   }

   public List<SignalConnector> getHide_outputs() {
      List<SignalConnector> result = new ArrayList<SignalConnector>();
      int port_num = 1;
      for(Signal out : block_wiring.getOuts()) {
         /*assert out != null;*/
         if (out != null && !flow.getPOuts().contains(out)) {
            result.add(new SignalConnector(out,
               new Port(block, port_num, PortDir.OUTPUT)));
         }
         port_num++;
      }
      return result;
   }

   public List<SignalConnector> getHide_all() {
      List<SignalConnector> result = new ArrayList<SignalConnector>();
      result.addAll(getHide_inputs());
      result.addAll(getHide_outputs());
      return result;
   }

   /* Utility methods for creation. */

   public static List<FlowConnector> createList(BlockWiring block_wiring,
      Block block) {
      List<FlowConnector> result = new ArrayList<FlowConnector>();
      for(Flow flow : block_wiring.getFlows()) {
         result.add(new FlowConnector(block_wiring, flow, block));
      }
      return result;
   }
}
