package org.zeyda.clawcircus.Toolbox.st;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;

import org.zeyda.clawcircus.Data.ClaSP.BlockWiringType;

import org.zeyda.clawcircus.utils.LatexUtils;

import java.util.List;
import java.util.ArrayList;

public class BlockConnector {
   private final Block block;

   public BlockConnector(Block block) {
      assert block != null;
      this.block = block;
   }

   /* StringTemplate interface methods. */

   public String getClawz_name() {
      return LatexUtils.encode(block.getClawZName());
   }

   public List<SignalConnector> getInterface() {
      return SignalConnector.createList(
         block.getBlockWiring().getInterface());
   }

   public boolean getIs_subsystem() {
      return block.isSubSystem();
   }

   public List<SignalConnector> getInternal_interface() {
      assert block.isSubSystem();
      SubSystem subsystem = (SubSystem) block;
      return SignalConnector.createList(
         subsystem.getBlockWiring(BlockWiringType.INNER).getInterface());
   }

   public List<SignalConnector> getExternal_interface() {
      assert block.isSubSystem();
      SubSystem subsystem = (SubSystem) block;
      return SignalConnector.createList(
         subsystem.getBlockWiring(BlockWiringType.OUTER).getInterface());
   }

   /* Utility method for creation. */

   public static List<BlockConnector> createList(SubSystem subsystem) {
      List<BlockConnector> result = new ArrayList<BlockConnector>();
      for(Block block : subsystem) {
         if (block.getProperty("translatable", Boolean.class)) {
            result.add(new BlockConnector(block));
         }
      }
      return result;
   }
}
