package org.zeyda.clawcircus.Toolbox;

import org.zeyda.clawcircus.IO.ClaSP.ClaSPJAXB;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.*;

import org.zeyda.clawcircus.utils.MiscUtils;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

import java.io.File;

public class ClaSPLibrary {
   /* Isolate the following property into configuration file at some point. */
   public static final String BLOCK_LIBRARY_FILE = "clasp/blocklibrary.xml";

   private static ClaSPXml block_library;

   static {
      load();
      assert block_library != null;
   }

   private static @SuppressWarnings("unchecked") void load() {
      JAXBElement<ClaSPXml> jaxb_root;
      try {
         jaxb_root = (JAXBElement<ClaSPXml>)
            ClaSPJAXB.getUnmarshaller().unmarshal(new File(BLOCK_LIBRARY_FILE));
      }
      catch(JAXBException e) {
         System.out.println(
            "Error reading ClaSP block library from " + BLOCK_LIBRARY_FILE);
         System.out.println(e.toString());
         System.exit(-1);
         throw new AssertionError(); /* Never reached. */
      }
      block_library = jaxb_root.getValue();
   }

   public static void reload() {
      load();
   }

   public static ClaSPXml getRoot() {
      return getClaSP();
   }

   public static ClaSPXml getClaSP() {
      return block_library;
   }

   public static BlockTypeXml getBlockType(String name) {
      ClaSPXml clasp = getClaSP();
      BlockLibraryXml block_library = clasp.getBlockLibrary();
      for(BlockTypeXml block_type : block_library.getBlockType()) {
         if (block_type.getName().equals(name)) {
            return block_type;
         }
      }
      return null; /* No corresponding entry found. */
   }

   public static BlockWiringXml getBlockWiring(String name) {
      ClaSPXml clasp = getClaSP();
      BlockTypeXml block_type = getBlockType(name);
      if (block_type == null) {
         return null; /* No corresponding entry found. */
      }
      return block_type.getBlockWiring();
   }

   public static Integer parseInps(BlockTypeXml block_type) {
      String inps = block_type.getBlockWiring().getInps();
      if (inps == null) {
         return 0;
      }
      inps = inps.trim().toLowerCase();
      if (inps.equals("varlength")) {
         return null;
      }
      assert MiscUtils.canBeParsedAsInt(inps);
      return Integer.parseInt(inps);
   }

   public static Integer parseOuts(BlockTypeXml block_type) {
      String outs = block_type.getBlockWiring().getOuts();
      if (outs == null) {
         return 0;
      }
      outs = outs.trim().toLowerCase();
      if (outs.equals("varlength")) {
         return null;
      }
      assert MiscUtils.canBeParsedAsInt(outs);
      return Integer.parseInt(outs);
   }
}
