package org.zeyda.clawcircus.ProofPower;

import java.util.Stack;

import java.util.regex.Pattern;
import java.util.regex.Matcher;

public class DocParser {
   public static void parseDoc(String text) {
      Pattern pattern = Pattern.compile("val[\\s]+([\\S]+)[\\s]*=[\\s]*");
      Matcher matcher = pattern.matcher(text);
      Stack<Character> brackets = new Stack<Character>();
      int theorem_count = 0;
      int index = 0;
match_loop:
      while (matcher.find(index)) {
         String val_decl = matcher.group();
         String val_name = matcher.group(1);
         index = matcher.end();
         StringBuilder val_body = new StringBuilder();
         brackets.clear();
         for (; index < text.length(); index++) {
            char c = text.charAt(index);
            val_body.append(c);
            if (c == '(') {
               brackets.push(c);
            }
            if (c == ')') {
               if (brackets.empty()) {
                  /* Matching failed, silently continue. */
                  continue match_loop;
               }
               assert brackets.peek() == '(';
               brackets.pop();
            }
            if (c == ';' && brackets.empty()) {
               break;
            }
         }
         /* System.out.println(val_decl + val_body);*/
         if (val_body.indexOf("save_thm") != -1) {
            theorem_count++;
         }
         /*printLine();*/
      }
      System.out.println("Number of theorems parsed: " + theorem_count);
   }

   private static void printLine() {
      for (int index = 0; index < 80; index++) {
         System.out.print("-");
      }
      System.out.println();
   }
}
