package org.zeyda.clawcircus.Data.Simulink;

/* Abstract class implemented by MdlAttribute and MdlBlock. */

public abstract class MdlElement implements Cloneable {
   private String name;
   private MdlBlock parent;

   protected MdlElement(String name) {
      setName(name);
      parent = null;
   }

   public String getName() {
      return name;
   }

   protected void setName(String name) {
      assert name != null;
      /*assert name.trim().length() != 0;*/
      this.name = name.trim();
      this.name = name;
   }

   public MdlBlock getParent() {
      return parent;
   }

   public void setParent(MdlBlock parent) {
      assert !(hasParent() && parent != null);
      this.parent = parent;
   }

   public boolean hasParent() {
      return getParent() != null;
   }

   public void remove() {
      if (hasParent()) {
         getParent().remove(this);
      }
      assert !hasParent();
   }

   /* The following methods reduce the need for instanceof operator calls. */

   public boolean isAttribute() {
      return this instanceof MdlAttribute;
   }

   public boolean isBlock() {
      return this instanceof MdlBlock;
   }

   public int getLevel() {
      int level = 0;
      for(MdlElement e = this; e.hasParent(); e = e.getParent()) {
         level++;
      }
      return level;
   }

   /* Making the clone() method protected is done on purpose as we want the
    * subclass to override this method in any case. */

   protected Object clone() {
      MdlElement clone;
      try {
         clone = (MdlElement) super.clone();
      }
      catch(CloneNotSupportedException e) {
         throw new AssertionError(e); /* Should never happen! */
      }
      clone.setParent(null);
      return clone;
   }

   /* The following method must be implemented by the subclass. */

   public abstract String serialise();
}
