package org.zeyda.clawcircus.Data.Simulink;

public class MdlAttribute extends MdlElement {
   protected String value;

   public MdlAttribute(String name, String value) {
      super(name);
      setValue(value);
   }

   public String getValue() {
      return value;
   }

   public void setValue(String value) {
      assert value != null;
      /*assert value.trim().length() != 0;*/
      this.value = value.trim();
      this.value = value;
   }

   public String serialise() {
      String inter_space = " ";
      if (Formatting.ALIGN_ATTRIBUTE_VALUES) {
         if (hasParent()) {
            int diff = getParent().getMaxLengthName() - getName().length();
            for(; diff > 0; diff--) {
               inter_space = " " + inter_space;
            }
         }
      }
      return getName() + inter_space + getValue();
   }

   public Object clone() {
      return (MdlAttribute) super.clone();
   }

   public @Override String toString() {
      return serialise();
   }
}
