package org.zeyda.clawcircus.Data.Diagram;

import org.zeyda.clawcircus.utils.ClawZUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class Path extends ArrayList<Block> implements Comparable<Path> {
   public Path() {
      super();
   }

   public Path(Block block) {
      for(Block next = block; next != null; next = next.getParent()) {
         add(next);
      }
      Collections.reverse(this);
   }

   public int length() {
      return size();
   }

   public Path subtract(Path path) {
      int index;
      for(index = 0; index < size(); index++) {
         if (index == path.size() || !get(index).equals(path.get(index))) {
            break;
         }
      }
      Path result = new Path();
      for(; index < size(); index++) {
         result.add(get(index));
      }
      return result;
   }

   public String toString(String separator) {
      StringBuilder result = new StringBuilder();
      boolean first = true;
      for(Block element : this) {
         if (!first) {
            result.append(separator);
         }
         result.append(ClawZUtils.toClawZName(element.getName()));
         first = false;
      }
      return result.toString();
   }

   public String getClawZName() {
      return toString("__");
   }

   public String getZSelectionStmt() {
      return toString(".");
   }

   /* In essence we use a lexicographical ordering on blocks. */

   public int compareTo(Path obj) {
      Iterator<Block> iter1 = this.iterator();
      Iterator<Block> iter2 = obj.iterator();
      while(iter1.hasNext() || iter2.hasNext()) {
         if (!iter1.hasNext()) {
            assert iter2.hasNext();
            return -1;
         }
         if (!iter2.hasNext()) {
            assert iter1.hasNext();
            return 1;
         }
         Block block1 = iter1.next();
         Block block2 = iter2.next();
         if (!block1.equals(block2)) {
            return block1.compareTo(block2);
         }
      }
      return 0;
   }

   public @Override String toString() {
      return toString("/");
   }
}
