package org.zeyda.clawcircus.Data.Diagram.BlockTypes.custom;

import org.zeyda.clawcircus.Data.Simulink.MdlBlock;

import org.zeyda.clawcircus.utils.MdlUtils;

import org.zeyda.clawcircus.exceptions.MdlSemanticException;

/* Maybe extend at some point the Block class to support processing of Ports
 * attributes upon initialisation. Then this class would become redundant. */

public class SFunction extends
   org.zeyda.clawcircus.Data.Diagram.BlockTypes.gen.SFunction {

   public SFunction() {
      setProperty("infer_inputs_dynamically", false);
      setProperty("infer_outputs_dynamically", false);
   }

   public @Override void initialise() throws MdlSemanticException {
      super.initialise();
      if (hasAnnotation(MdlBlock.class)) {
         MdlBlock mdl_block = getAnnotation(MdlBlock.class);
         String ports_str = MdlUtils.getStringAttribute("Ports", mdl_block);
         if (!(ports_str.startsWith("[") && ports_str.endsWith("]"))) {
            throw new MdlSemanticException(
               "Illegal format for Ports attribute.", mdl_block);
         }
         String[] ports =
            ports_str.substring(1, ports_str.length() - 1).split(",");
         if (ports.length != 2) {
            throw new MdlSemanticException(
               "Illegal format for Ports attribute.", mdl_block);
         }
         int inputs, outputs;
         try {
            inputs = Integer.parseInt(ports[0].trim());
            outputs = Integer.parseInt(ports[1].trim());
         }
         catch(NumberFormatException e) {
            throw new MdlSemanticException(
               "Illegal format for Ports attribute.", mdl_block);
         }
         updateLinks(inputs, outputs);
      }
   }
}
