package org.zeyda.clawcircus.Data.Diagram;

import org.zeyda.clawcircus.Data.Simulink.MdlBlock;

import org.zeyda.clawcircus.IO.ClaSP.jaxb.*;

import org.zeyda.clawcircus.Toolbox.ClaSPLibrary;

import org.zeyda.clawcircus.utils.MdlUtils;

import org.zeyda.clawcircus.exceptions.BlockInstantiationException;
import org.zeyda.clawcircus.exceptions.MdlSemanticException;

import java.util.List;
import java.util.LinkedList;

public class BlockFactory {
   private static List<String> class_locs;

   static {
      class_locs = new LinkedList<String>();
      defaults();
   }

   public static void register(String location) {
      /* Add new location to the beginning of the search list. */
      class_locs.add(0, location);
   }

   public static void defaults() {
      class_locs.clear();
      register("org.zeyda.clawcircus.Data.Diagram.BlockTypes.gen");
      register("org.zeyda.clawcircus.Data.Diagram.BlockTypes.custom");
   }

   public static Block create(MdlBlock mdl_block) throws
      BlockInstantiationException {
      assert mdl_block != null;
      String block_type;
      try {
         block_type = MdlUtils.getStringAttribute("BlockType", mdl_block);
      }
      catch(MdlSemanticException e) {
         throw new BlockInstantiationException(e);
      }
      Block block = create(block_type);
      assert block != null;
      block.setAnnotation(mdl_block);
      try {
         block.initialise();
      }
      catch (MdlSemanticException e) {
         throw new BlockInstantiationException(e);
      }
      return block;
   }

   public static Block create(String block_type) throws
      BlockInstantiationException {
      Block block = null;
      String class_name = BlockUtil.convBlockTypeToClass(block_type);
      /* First check if a class exists we can instantiate. */
      Class clazz = null;
      for(String location : class_locs) {
         try {
            clazz = null;
            clazz = Class.forName(location + "." + class_name);
            if (Block.class.isAssignableFrom(clazz)) {
               break;
            }
         }
         catch (ClassNotFoundException e) { }
      }
      if (clazz != null) {
         try {
            block = (Block) clazz.newInstance();
         }
         catch(InstantiationException e) {
            throw new BlockInstantiationException(e);
         }
         catch(IllegalAccessException e) {
            throw new BlockInstantiationException(e);
         }
      }
      else { /* Only if this fails try and create a generic block. */
         block = createGenericBlock(block_type);
      }
      if (block == null) {
         throw new BlockInstantiationException(
            "No class or entry in ClaSP library for " + block_type + " block.");
      }
      return block;
   }

   private static Block createGenericBlock(String block_type) {
      BlockTypeXml block_type_xml = ClaSPLibrary.getBlockType(block_type);
      Block block = null;
      if (block_type_xml != null) {
         assert block_type.equals(block_type_xml.getName());
         BlockWiringXml block_wiring_xml = block_type_xml.getBlockWiring();
         Integer inputs = ClaSPLibrary.parseInps(block_type_xml);
         Integer outputs = ClaSPLibrary.parseOuts(block_type_xml);
         boolean translatable = block_type_xml.isTranslatable();
         boolean state = block_type_xml.isState();
         block =
            new GenericBlock(block_type, inputs, outputs, translatable, state);
      }
      return block;
   }
}
