package org.zeyda.clawcircus.Data.ClawZ;

import org.zeyda.clawcircus.utils.StringUtils;

import java.util.List;
import java.util.ArrayList;

/* There is some really nice algorithmic coding in this class. */

public class PatternMatcher {
   public static boolean match(String path_str, String patt_str) {
      String[] path = factorise(path_str);
      String[] patt = factorise(patt_str);
      for(String element : path) {
         assert !element.equals("*");
         assert !element.equals("?");
      }
      return match(path, patt);
   }

   private static boolean match(String[] path, String[] patt) {
      return match(path, patt, 0, 0);
   }

   private static boolean match(String[] path, String[] patt, int i, int j) {
      assert i <= path.length;
      assert j <= patt.length;
      if (j == patt.length) {
         return i == path.length;
      }
      if (i == path.length) {
         /* Subtle: there may still be some trailing '*'s to be consumed. */
         if (j < patt.length && !patt[j].equals("*")) {
            return false;
         }
      }
      if (patt[j].equals("*")) {
         /* Increases efficiency in cases where '*' concludes the pattern. */
         if (j == patt.length-1) {
            return true;
         }
         for(int x = i; x <= path.length; x++) {
            if (match(path, patt, x, j+1)) {
               return true;
            }
         }
         return false;
      }
      if (patt[j].equals("?") || path[i].equals(patt[j])) {
         return match(path, patt, i+1, j+1);
      }
      return false;
   }

   public static String[] factorise(String patt_str) {
      patt_str = StringUtils.unquote(patt_str.trim());
      List<String> elements = new ArrayList<String>();
      StringBuilder element = new StringBuilder();
      for(int index = 0; index <= patt_str.length(); index++) {
         /* Order of the tests is significant here. */
         if (index == patt_str.length() || patt_str.charAt(index) == '/') {
            elements.add(element.toString());
            element = new StringBuilder();
            continue;
         }
         if (patt_str.charAt(index) == '\\') {
            element.append(patt_str.charAt(index));
            index++;
            if (index == patt_str.length()) {
               /*assert false;*/
               continue;
            }
            if (!(patt_str.charAt(index) == '/' ||
               patt_str.charAt(index) == '?' ||
               patt_str.charAt(index) == '*')) {
               /*assert false;*/
            }
         }
         element.append(patt_str.charAt(index));
      }
      return elements.toArray(new String[0]);
   }
}
