package org.zeyda.clawcircus.Data.ClaSP;

import org.zeyda.clawcircus.Data.Diagram.PortBlock;
import org.zeyda.clawcircus.Data.Diagram.Link;

public class PortBlockSignal extends Signal {
   private final PortBlock block;

   public PortBlockSignal(PortBlock block) {
      /*assert block != null;*/
      super(block.getUniqueLink());
      this.block = block;
   }

   public PortBlock getPortBlock() {
      return block;
   }

   public @Override String getName() {
      return block.getPath().getClawZName();
   }

   public @Override Signal lift() {
      if (block.hasParent()) {
         Link link = block.resolveIntoPort().getLink();
         if (link != null) {
            return link.getSignal();
         }
      }
      /*assert false;*/
      return null;
   }
}
