package org.zeyda.clawcircus.Data.ClaSP;

import org.zeyda.clawcircus.collections.*;
import org.zeyda.clawcircus.collections.impl.*;

/* Immutable class. */

public class Enabled {
   public static final Enabled ALWAYS = new Enabled(true);
   private final SignalSet signals;

   protected Enabled(boolean always) {
      assert always;
      /* What would Enabled(false) be useful for? */
      this.signals = new SignalSetImpl();
   }

   public Enabled(SignalSet signals) {
      assert signals != null;
      this.signals = signals;
   }

   public boolean isAlways() {
      return signals.isEmpty();
   }

   public SignalSet getSignals() {
      /*assert !isAlways();*/
      return signals;
   }

   public Enabled lift() {
      return new Enabled(signals.lift());
   }

   public @Override boolean equals(Object obj) {
      if (obj instanceof Enabled) {
         if (isAlways()) {
            return ((Enabled) obj).isAlways();
         }
         assert signals != null;
         return signals.equals(((Enabled) obj).signals);
      }
      return super.equals(obj);
   }

   public @Override int hashCode() {
      return (signals == null ? 0 : signals.hashCode());
   }

   public @Override String toString() {
      if (isAlways()) {
         return "always";
      }
      else {
         return "" + signals;
      }
   }
}
