import org.zeyda.clawcircus.IO.xml.*;

import javax.xml.XMLConstants;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.MarshalException;

import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Schema;

import java.io.File;

class Test {
   public static void main(String[] args) throws Exception {
      JAXBContext context =
         JAXBContext.newInstance("org.zeyda.clawcircus.IO.CLaSP.xml");
      SchemaFactory schema_factory =
         SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
      Schema schema =
         schema_factory.newSchema(new File("xls/clasp_blocklibrary.xsl"));

      Marshaller marshaller = context.createMarshaller();
      marshaller.setProperty("jaxb.formatted.output", true);
      marshaller.setSchema(schema);

      ObjectFactory factory = new ObjectFactory();

      BlockLibraryType blocklibrary_type = factory.createBlockLibraryType();
      BlockTypeType blocktype_type = factory.createBlockTypeType();
      blocklibrary_type.getBlockType().add(blocktype_type);

      blocktype_type.getInps().add(1);
      blocktype_type.getInps().add(2);
      blocktype_type.getOuts().add(1);

      BlockWiringType wiring_type = factory.createBlockWiringType();
      blocktype_type.setBlockWiring(wiring_type);

      FlowsType flows_type = factory.createFlowsType();

      FlowType flow1 = factory.createFlowType();
      FlowType flow2 = factory.createFlowType();
      flows_type.getFlow().add(flow1);
      flows_type.getFlow().add(flow2);

      PortSpecType port_spec1 = factory.createPortSpecType();
      PortSpecType port_spec2 = factory.createPortSpecType();
      flow1.setRinps(port_spec1);
      flow1.setPouts(port_spec2);
      flow2.setRinps(port_spec2);
      flow2.setPouts(port_spec1);
      EnabledPortSpecType port_spec3 = factory.createEnabledPortSpecType();

      port_spec1.getPort().add(1);
      port_spec1.getPort().add(2);
      port_spec2.getPortPattern().add("1,2");
      port_spec3.setAlways(true);

      wiring_type.setEnabled(port_spec3);
      wiring_type.setFlows(flows_type);

      blocktype_type.setName("Sum");
      try {
         marshaller.marshal(factory.createBlockLibrary(blocklibrary_type),
            System.out);
      }
      catch(MarshalException e) {
         System.out.println(e.toString());
      }
   }
}
