package org.zeyda.clawcircus.Toolbox.st;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Path;

import org.zeyda.clawcircus.utils.LatexUtils;
import org.zeyda.clawcircus.utils.DiagramUtils;

import java.util.List;
import java.util.ArrayList;

public class StateInfoConnector {
   public final String STATE_SUFFIX = "_state";
   private final Block root;
   private final Block block;

   public StateInfoConnector(Block root, Block block) {
      assert root != null;
      assert block != null;
      assert block.getProperty("state", Boolean.class);
      this.root = root;
      this.block = block;
   }

   /* StringTemplate interface methods. */

   public String getBlock() {
      return LatexUtils.encode(block.getClawZName());
   }

   public String getUnprimed() {
      return getBlock() + LatexUtils.encode(STATE_SUFFIX);
   }

   public String getPrimed() {
      return getUnprimed() + "'";
   }

   public String getSelect_stmt() {
      Path select_path = block.getPath().subtract(root.getPath());
      assert
         block.getPath().size() == root.getPath().size() + select_path.size();
      if (select_path.isEmpty()) {
         /* Note that it is crucial to return null here for the respective
          * template to be able to suitably deal with this special case. */
         return null;
      }
      return LatexUtils.encode(select_path.getZSelectionStmt());
   }

   public String getType() {
      return "\\universe";
   }

   /* Utility method for creation. */

   public static List<StateInfoConnector> createList(Block root) {
      List<StateInfoConnector> result = new ArrayList<StateInfoConnector>();
      for(Block child : DiagramUtils.getSubordinateBlocksWithState(root)) {
         assert child.getProperty("state", Boolean.class);
         result.add(new StateInfoConnector(root, child));
      }
      return result;
   }
}
