package org.zeyda.clawcircus.Parser;

import org.zeyda.clawcircus.exceptions.ParserException;

public class Token {
   public static final Token EOF_TOKEN = new Token(TokenType.EOF, 0);

   private TokenType type;
   private String text;
   private int line;

   public Token(TokenType type, String text, int line) {
      this.type = type;
      this.text = text;
      this.line = line;
   }

   public Token(TokenType type, int line) {
      this(type, null, line);
   }

   public TokenType getType() {
      return type;
   }

   public String getText() {
      return text;
   }

   public int getLine() {
      return line;
   }

   public boolean isText() {
      return type == TokenType.TEXT;
   }

   public boolean isQuotedText() {
      return type == TokenType.QUOTED_TEXT;
   }

   public boolean isLCURLY() {
      return type == TokenType.LCURLY;
   }

   public boolean isRCURLY() {
      return type == TokenType.RCURLY;
   }

   public boolean isEOF() {
      return type == TokenType.EOF;
   }

   public boolean isValidName() {
      /* Not fully implemented yet, check validity of characters too. */
      return isText() /* && .. */;
   }

   public boolean isValidValue() {
      return isText() || isQuotedText() /* && .. */;
   }

   public String toString() {
      String result;
      switch(type) {
         case TEXT:
            result = text;
            break;

         case QUOTED_TEXT:
            result = text;
            break;

         case LCURLY:
            result = "{";
            break;

         case RCURLY:
            result = "}";
            break;

         case EOF:
            result = "EOF";
            break;

         default:
            throw new AssertionError();
      }
      return result;
   }
}
