package org.zeyda.clawcircus.IO.ClaSP;

import javax.xml.XMLConstants;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;

import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.SAXException;

import java.io.File;

public class ClaSPJAXB {
   /* Isolate this as a configurable property at some point. */
   public static final String CLASP_XSD_RESOURCE = "resources/jaxb/clasp.xsd";
   public static final String CLASP_XSD_FILE = "src/resources/jaxb/clasp.xsd";

   private static JAXBContext context;
   private static Schema schema;
   private static Marshaller marshaller;
   private static Unmarshaller unmarshaller;

   static {
      try {
         init();
      }
      catch(Exception e) {
         System.err.println("Error initialising " + ClaSPJAXB.class);
         System.err.println(e.toString());
         System.exit(-1);
      }
   }

   /* Private initialisation methods. */

   private static void init() throws JAXBException, SAXException {
      initJAXBContext();
      initSchema();
      initMarshaller();
      initUnmarshaller();
   }

   private static void initJAXBContext() throws JAXBException {
      context = JAXBContext.newInstance(
         ClaSPJAXB.class.getPackage().getName() + ".jaxb");
   }

   private static void initSchema() throws SAXException {
      SchemaFactory factory =
         SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
      if (ClassLoader.getSystemResource(CLASP_XSD_RESOURCE) != null) {
         schema = factory.newSchema(
            ClassLoader.getSystemResource(CLASP_XSD_RESOURCE));
      }
      else {
         /* This is necessary when bootstrapping compilation. */
         schema = factory.newSchema(new File(CLASP_XSD_FILE));
      }
   }

   private static void initMarshaller() throws JAXBException {
      assert context != null;
      assert schema != null;
      marshaller = context.createMarshaller();
      /* Can we somehow set indentation to two spaces? */
      marshaller.setProperty("jaxb.formatted.output", true);
      marshaller.setSchema(schema);
   }

   private static void initUnmarshaller() throws JAXBException {
      assert context != null;
      assert schema != null;
      unmarshaller = context.createUnmarshaller();
      unmarshaller.setSchema(schema);
   }

   /* Public methods. */

   public static Marshaller getMarshaller() {
      return marshaller;
   }

   public static Unmarshaller getUnmarshaller() {
      return unmarshaller;
   }
}
