package org.zeyda.clawcircus.Data.Diagram;

import org.zeyda.clawcircus.Data.ClaSP.Signal;

import org.zeyda.clawcircus.collections.*;
import org.zeyda.clawcircus.collections.impl.*;

/* Note that while each link has only one source port, there can be an
 * arbitrary number of destination ports i.e. if the respective wire
 * branches. A Link object thus represents a "network of interconnected
 * wires". */

public class Link {
   protected Port src_port;
   protected final PortSet dst_ports;

   /* Caches signal instance associated with this Link object. */
   protected final Signal signal;

   public Link() {
      src_port = null;
      dst_ports = new PortSetImpl();
      signal = new Signal(this);
   }

   public Link(Port... ports) {
      this();
      attachToPorts(ports);
   }

   public Port getSrcPort() {
      return src_port;
   }

   public boolean isSrcConnected() {
      return src_port != null;
   }

   public PortSet getDstPorts() {
      return dst_ports;
   }

   public boolean hasDstPorts() {
      return !dst_ports.isEmpty();
   }

   public Block getSrcBlock() {
      /*assert src_block != null;*/
      if (src_port == null) {
         return null;
      }
      else {
         return src_port.getBlock();
      }
   }

   public BlockSet getDstBlocks() {
      BlockSet result = new BlockSetImpl();
      for(Port port : dst_ports) {
         result.add(port.getBlock());
      }
      return result;
   }

   public PortSet getConnectedPorts() {
      PortSet result = new PortSetImpl();
      result.add(getSrcPort());
      result.addAll(getDstPorts());
      return result;
   }

   public BlockList getConnectedBlocks() {
      BlockList result = new BlockListImpl();
      if (isSrcConnected()) {
         result.add(getSrcBlock());
      }
      result.addAll(getDstBlocks());
      return result;
   }

   public void attachToPort(Port port) {
      port.getBlock().attachLink(this, port);
      switch(port.getDir()) {
         case OUTPUT:
            /*detachFromPort();*/
            assert !isSrcConnected();
            src_port = port;
            break;

         case INPUT:
            /*assert dst_ports.contains(port);*/
            dst_ports.add(port);
            break;
      }
   }

   public void detachFromPort(Port port) {
      port.getBlock().detachLink(this, port);
      switch(port.getDir()) {
         case OUTPUT:
            assert isSrcConnected();
            src_port = null;
            break;

         case INPUT:
            assert dst_ports.contains(port);
            dst_ports.remove(port);
            break;
      }
   }

   public void attachToPorts(Port... ports) {
      for(Port port : ports) {
         attachToPort(port);
      }
   }

   public void detachFromPorts(Port... ports) {
      for(Port port : ports) {
         detachFromPort(port);
      }
   }

   public void detachAll() {
      detachFromPorts(getConnectedPorts().toArray(new Port[0]));
   }

   public Signal getSignal() {
      return signal;
   }

   public String toString() {
      return src_port.toString() + " -> " + dst_ports.toString();
   }
}
