package org.zeyda.clawcircus.Data.Diagram;

import org.zeyda.clawcircus.collections.*;
import org.zeyda.clawcircus.collections.impl.*;

/* Only subclass of Block which is not instantiated through BlockFactory. */

public final class GenericBlock extends Block {
   private final String block_type;

   public GenericBlock(String block_type, Integer inputs, Integer outputs,
      boolean translatable, boolean state) {
      super(inputs == null ? 0 : inputs, outputs == null ? 0 : outputs);
      assert block_type != null;
      this.block_type = block_type;
      setProperty("infer_inputs_dynamically", inputs == null);
      setProperty("infer_outputs_dynamically", outputs == null);
      setProperty("translatable", translatable);
      setProperty("state", state);
   }

   public @Override String getBlockType() {
      return block_type;
   }

   public @Override BlockList getChildren() {
      return new BlockListImpl();
   }
}
