package org.zeyda.clawcircus.Data.Diagram;

import java.util.Comparator;
import java.util.Map;
import java.util.HashMap;

public class BlockComparator implements Comparator<Block> {
   public static final Map<String, Integer> BLOCK_TYPES_ORDER;

   static {
      BLOCK_TYPES_ORDER = new HashMap<String, Integer>();
      BLOCK_TYPES_ORDER.put("SubSystem" , 0);
      BLOCK_TYPES_ORDER.put("Inport", 1);
      BLOCK_TYPES_ORDER.put("Outport", 2);
      BLOCK_TYPES_ORDER.put("EnablePort", 3);
      BLOCK_TYPES_ORDER.put("TriggerPort", 4);
      BLOCK_TYPES_ORDER.put("ActionPort", 5);
      /* All the other blocks should be ordered alphabetically. */
   }

   public int compare(Block b1, Block b2) {
      return b1.getPath().compareTo(b2.getPath());
   }
}
