package org.zeyda.clawcircus.Data.ClawZ;

import org.zeyda.clawcircus.Data.Simulink.*;

import java.util.List;

public class LibraryMetaFile {
   protected List<MdlBlock> block_spec_list;

   public LibraryMetaFile(List<MdlBlock> block_spec_list) {
      /* Maybe specify some assertions on block_spec_list here. */
      this.block_spec_list = block_spec_list;
   }

   public MdlBlock findMatch(MdlBlock block) {
      MdlBlock block_spec_match = null;
      for(MdlBlock block_spec : block_spec_list) {
         if (matches(block, block_spec)) {
            block_spec_match = block_spec;
         }
      }
      return block_spec_match;
   }

   public boolean matches(MdlBlock block) {
      return findMatch(block) != null;
   }

   protected static boolean matches(MdlBlock block, MdlBlock block_spec) {
      /* Compare BlockPath. */
      if (block_spec.hasAttribute("BlockPath")) {
         String patt_str = block_spec.getAttributeValue("BlockPath");
         if (!PatternMatcher.match(block.getBlockPath(), patt_str)) {
            return false; /* Match failed. */
         }
      }
      if (!block_spec.containsBlock("SelectionParameters")) {
         /* Possibly print a warning message here. */
         return false;
      }
      /* Compare SelectionParameters. */
      MdlBlock select_param = block_spec.getBlock("SelectionParameters");
      for (MdlElement element : select_param) {
         if (element.isAttribute()) {
            MdlAttribute attr = (MdlAttribute) element;
            if (!(block.hasAttribute(attr.getName()) &&
            block.getAttributeValue(attr.getName()).equals(attr.getValue()))) {
               return false; /* Match failed. */
            }
         }
      }
      return true; /* Match succeeded. */
   }

   public String serialise() {
      StringBuilder result = new StringBuilder();
      for(MdlElement element : block_spec_list) {
         result.append(element.serialise() + "\n");
      }
      return result.toString();
   }

   public @Override String toString() {
      return serialise();
   }
}
