package org.zeyda.clawcircus.Data.ClaSP;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Link;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;
import org.zeyda.clawcircus.Data.Diagram.ResolveMethod;

import org.zeyda.clawcircus.collections.*;
import org.zeyda.clawcircus.collections.impl.*;

import org.zeyda.clawcircus.utils.ClaSPUtils;

/* It slightly concerns me that there are a few assertions in this class, in
 * particular I haven't got a clear idea yet how to establish some of them. */

public class Signal { /* Immutable class. */
   public static final String SIGNAL_SUFFIX = "_out";

   protected final Link wire;

   public Signal(Link wire) {
      assert wire != null;
      /*assert wire.isSrcConnected();*/
      this.wire = wire;
   }

   public Link getLink() {
      return wire;
   }

   public String getName() {
      assert wire.isSrcConnected();
      Block src_block = wire.getSrcBlock();
      String result = src_block.getPath().getClawZName();
      if (!src_block.isInport()) {
         result += SIGNAL_SUFFIX;
      }
      if (src_block.getOutputPortsNum() > 1) {
         result += wire.getSrcPort().getPortNum();
      }
      return result;
   }

   public Signal lift() {
      if (wire.isSrcConnected()) {
         Block block = wire.getSrcBlock();
         assert block.isPort();
         if (block.hasParent()) {
            Link link = block.resolveIntoPort().getLink();
            if (link != null) {
               return link.getSignal();
            }
         }
      }
      /*assert false;*/
      return null;
   }

   public Signal unlift() {
      if (wire.isSrcConnected()) {
         assert wire.getSrcBlock().isSubSystem();
         return ClaSPUtils.getSignalFromPort(
            wire.getSrcPort(), ResolveMethod.INTERNAL);
      }
      /*assert false;*/
      return null;
   }

   /* The tracing method doesn't yet take into account enabling signals. */

   public SignalSet traceBackToInputs() {
      SignalSet result = new SignalSetImpl();
      /*assert wire.isSrcConnected();*/
      if (wire.isSrcConnected()) {
         if (connectsInport()) {
            result.add(this);
         }
         else {
            Block src_block = wire.getSrcBlock();
            BlockWiring block_wiring = src_block.getBlockWiring();
            Flow flow = block_wiring.getFlow(this);
            if (flow == null) {
               assert false;
               /* Whether we raise an error here depends on how robust we like
                * the calculation of BlockWiring (and thus translation) to be.
                * Besides it could be debatable whether we return an empty or
                * complete set of signals, though the later seems to make more
                * sense. */
               /*result.addAll(block_wiring.getInps());*/
            }
            else {
               for(Signal inp : flow.getRInps()) {
                  result.addAll(inp.traceBackToInputs());
               }
            }
         }
      }
      return result;
   }

   public boolean connectsInport() {
      return wire.isSrcConnected() && wire.getSrcBlock().isInport();
   }

   /* Signal objects are equal if they refer to the same wire. */

   public @Override boolean equals(Object obj) {
      if (obj instanceof Signal) {
         return wire.equals(((Signal) obj).wire);
      }
      return false;
   }

   public @Override int hashCode() {
      return wire.hashCode();
   }

   public String toString() {
      return getName();
   }
}
