package org.zeyda.clawcircus.Data.ClaSP;

import org.zeyda.clawcircus.collections.*;

public class Flow {
   protected final Enabled enabled;
   protected final boolean ordered;
   protected final SignalSet rinps;
   protected final SignalSet pouts;

   public Flow(Enabled enabled, boolean ordered, SignalSet rinps, SignalSet
      pouts) {
      /* Possibly identify more consistency requirements here. */
      assert enabled != null;
      assert rinps != null;
      assert pouts != null;
      this.enabled = enabled;
      this.ordered = ordered;
      this.rinps = rinps;
      this.pouts = pouts;
   }

   public Flow(SignalSet rinps, SignalSet pouts) {
      this(Enabled.ALWAYS, false, rinps, pouts);
   }

   public Enabled getEnabled() {
      return enabled;
   }

   public boolean isOrdered() {
      return ordered;
   }

   public SignalSet getRInps() {
      return rinps;
   }

   public SignalSet getPOuts() {
      return pouts;
   }

   public Flow lift() {
      return new Flow(enabled.lift(), ordered, rinps.lift(), pouts.lift());
   }

   public @Override boolean equals(Object obj) {
      if (obj instanceof Flow) {
         return enabled.equals(((Flow) obj).enabled) &&
            ordered == ((Flow) obj).ordered &&
            rinps.equals(((Flow) obj).rinps) &&
            pouts.equals(((Flow) obj).pouts);
      }
      return super.equals(obj);
   }

   public @Override int hashCode() {
      return enabled.hashCode() ^ ((Boolean) ordered).hashCode() ^
         rinps.hashCode() ^ pouts.hashCode();
   }

   public @Override String toString() {
      StringBuilder result = new StringBuilder();
      result.append("{");
      result.append("enabled |-> " + enabled + ", ");
      result.append("ordered |-> " + ordered + ", ");
      result.append("rinps |-> " + rinps + ", ");
      result.append("pouts |-> " + pouts);
      result.append("}");
      return result.toString();
   }
}
