package org.zeyda.clawcircus.Application.Test;

import net.sourceforge.czt.session.SectionManager;

/*import net.sourceforge.czt.z.util.Factory;*/
import net.sourceforge.czt.circus.util.Factory;

/*import net.sourceforge.czt.z.ast.*;*/
import net.sourceforge.czt.circus.ast.*;

/*import net.sourceforge.czt.print.z.PrintUtils;*/
import net.sourceforge.czt.print.circus.PrintUtils;

import java.io.Writer;
import java.io.PrintWriter;

public class CZTTest {
   private static final Factory factory = new Factory();

   private static void writeLatexHeader(PrintWriter writer) {
      writer.println("\\documentclass{article}");
      writer.println("\\usepackage{circus}");
      writer.println("\\usepackage{circus_plus}");
      writer.println();
      writer.println("\\begin{document}");
   }

   private static void writeLatexFooter(PrintWriter writer) {
      writer.println("\\end{document}");
   }

   public static void main(String[] args) {
      /*OrPred or_ast = factory.createOrPred();
      or_ast.setLeftPred(factory.createTruePred());
      or_ast.setRightPred(factory.createFalsePred());*/
      GuardedAction guard_ast =
         factory.createGuardedAction(
            factory.createSkipAction(), factory.createFalsePred());

      PrintWriter writer = new PrintWriter(System.out);

      writeLatexHeader(writer);

      writer.println("\\subsubsection*{The following output was generated from a \\Circus\\ AST in CZT}");
      writer.println();

      PrintUtils.printLatex(
         /*or_ast, writer, new SectionManager("z"), "standard_toolkit");*/
         guard_ast, writer, new SectionManager("circus"), "circus_toolkit");
      writer.println();

      writeLatexFooter(writer);
      writer.flush();
   }
}
