package org.zeyda.clawcircus.Application;

import org.zeyda.clawcircus.Data.ClawZ.LibraryMetaFile;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;

import org.zeyda.clawcircus.Toolbox.MdlClawZAdaptor;
import org.zeyda.clawcircus.Toolbox.SimulinkAnalyser;

import org.zeyda.clawcircus.utils.AppUtils;
import org.zeyda.clawcircus.utils.FileUtils;

class SimulinkAnalyserApp {
   private static void welcome() {
      AppUtils.makeWelcome("Simulink Analyser");
   }

   private static void usage() {
      System.out.println(
         "Usage: analyse <file>.mdl [<file1>.lmf <file2>.lmf ..]");
      System.exit(-1);
   }

   private static void doAnalysis(MdlBlock model, LibraryMetaFile[] lmf_array) {
      MdlClawZAdaptor.invoke(model);
      SimulinkAnalyser.useColouredOutput(true);
      SimulinkAnalyser.invoke(model, lmf_array);
   }

   public static void main(String[] args) {
      if (args.length == 0) {
         usage();
      }
      welcome();
      System.out.println("Analysing Simulink file: " + args[0]);
      MdlBlock model = FileUtils.readMdl(args[0]);
      LibraryMetaFile[] lmf_array = new LibraryMetaFile[args.length-1];
      for(int i = 1; i < args.length; i++) {
         System.out.println("Validating against " + args[i]);
         lmf_array[i-1] = FileUtils.readLmf(args[i]);
      }
      System.out.println("---");
      doAnalysis(model, lmf_array);
   }
}
