package org.zeyda.clawcircus.Application;

import org.zeyda.clawcircus.Data.ClawZ.LibraryMetaFile;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.Data.Simulink.MdlElement;

import org.zeyda.clawcircus.Toolbox.MdlClawZAdaptor;
import org.zeyda.clawcircus.Toolbox.SimulinkAnalyser;

import org.zeyda.clawcircus.utils.FileUtils;
import org.zeyda.clawcircus.utils.ParserUtils;

class MdlMergeApp {
   private static void welcome() {
      System.out.println("Simulink Model Merger 2007 (c) by Michael Vernon.");
      System.out.println("--");
   }

   private static void usage() {
      System.out.println("Usage: merge <source file>.mdl <injection file>.mdl <target file>.mdl");
      System.out.println("-> Note that the target file, if existent, will be silently overwritten.");
      System.exit(-1);
   }

   private static void addExtAtts(MdlBlock sourceModel, MdlBlock extModel) {
      System.out.println("Scanning " + sourceModel.getAttribute("Name"));
      for (MdlElement element : sourceModel) {
         if (element.isBlock()){
            MdlBlock extBlock = getExtBlock((MdlBlock) element, extModel);
            if (extBlock != null){
               addExtAtts((MdlBlock) element, extBlock);
            }
         }
      }
      for(MdlElement extElement : extModel){
         if(!extElement.isBlock()){
            if(sourceModel.getAttribute(extElement.getName()) == null) {
               System.out.println("Adding " + extElement.getName());
               MdlElement newAttribute = extElement;
               newAttribute.setParent(null);
               sourceModel.add(newAttribute);
            }
         }
      }
   }

   private static MdlBlock getExtBlock(MdlBlock block, MdlBlock extBlock) {
      int found = 0;
      MdlBlock match = null;
      for(MdlElement extElement : extBlock) {
         if(extElement.isBlock()) {
            if(extElement.getName().equals(block.getName())) {
               MdlBlock blockRep = (MdlBlock) extElement;
               if(block.getAttribute("Name") != null) {
                  if(blockRep.getAttributeValue("Name").equals(
                     block.getAttributeValue("Name"))) {
                     match = blockRep;
                     found = found + 1;
                  }
               }
            }
         }
      }
      if (found > 1){
         System.out.println("ERROR extension file duplicates block names!");
         System.exit(-1);
      }
      return match;
   }

   public static void main(String[] args) {
      if (args.length != 3) {
         usage();
      }
      welcome();
      System.out.println(
         "Merging Simulink files: " + args[0] + " and " + args[1]);
      MdlBlock extModel = FileUtils.readMdl(args[1]);
      System.out.println("Reading from source model: " + args[0]);
      String text = FileUtils.readTextFile(args[0]);
      System.out.println("Parsing source model..");
      MdlBlock sourceModel = ParserUtils.parseMdl(text);
      System.out.println(
         "Merging Simulink files: " + args[0] + " and " + args[1]);
      addExtAtts(sourceModel, extModel);
      /* Added by Frank Zeyda */
      System.out.println("Adapting resulting model for ClawZ.");
      MdlClawZAdaptor.disableVerboseOutput();
      MdlClawZAdaptor.invoke(sourceModel);
      /* ******************** */
      FileUtils.writeMdl(args[2], sourceModel);
   }
}
