package org.zeyda.clawcircus.Application;

import org.zeyda.clawcircus.Data.Simulink.MdlBlock;

import org.zeyda.clawcircus.Toolbox.MdlClawZAdaptor;

import org.zeyda.clawcircus.utils.AppUtils;
import org.zeyda.clawcircus.utils.FileUtils;
import org.zeyda.clawcircus.utils.ParserUtils;

public class MdlClawZAdaptorApp {
   private static void welcome() {
      AppUtils.makeWelcome("Simulink Mdl Adaptor for ClawZ");
   }

   private static void usage() {
      System.out.println("Usage: adaptmdl <input file>.mdl <output file>.mdl");
      System.out.println(
      "-> Note that the output file if exists will be silently overwritten.");
      System.exit(-1);
   }

   public static void main(String[] args) {
      if (args.length != 2) {
         usage();
      }
      welcome();
      System.out.println("Reading from input file: " + args[0]);
      String text = FileUtils.readTextFile(args[0]);
      System.out.println("Parsing model..");
      MdlBlock model = ParserUtils.parseMdl(text);
      MdlClawZAdaptor.enableVerboseOutput();
      MdlClawZAdaptor.invoke(model);
      System.out.println("Writing modifications to output file: " + args[1]);
      FileUtils.writeMdl(args[1], model);
   }
}
