package org.zeyda.clawcircus.Application;

import org.zeyda.clawcircus.UI.AWTExceptionHandler;

public class GlobalErrorHandler {
   public static void init() {
      AWTExceptionHandler.register();
      register();
   }

   public static void raiseError(Throwable e, String msg) {
      if (e != null) {
         if (msg == null) {
            msg = e.getMessage();
         }
         System.out.print(e.getClass().getName());
         if (msg != null) {
            System.out.print(": " + msg);
         }
         System.out.println();
         e.printStackTrace(System.out);
      }
      else {
         assert msg != null;
         System.out.println(msg);
      }
      /*System.exit(-1);*/
   }

   public static void raiseError(Throwable e) {
      assert e != null;
      raiseError(e, null);
   }

   public static void raiseError(String msg) {
      assert msg != null;
      System.out.println(msg);
      System.exit(-1);
   }

   public static void warning(String msg) {
      System.out.println("[Warning] " + msg);
   }

   private static void register() {
      Thread.setDefaultUncaughtExceptionHandler(
         new Thread.UncaughtExceptionHandler() {
            public void uncaughtException(Thread t, Throwable e) {
               raiseError(e);
            }
         }
      );
   }
}
