package org.zeyda.clawcircus.Application.Build;

import org.zeyda.clawcircus.Toolbox.BlockTypesGen;

import org.zeyda.clawcircus.utils.AppUtils;

import javax.xml.bind.JAXBException;

import org.xml.sax.SAXException;

public class BlockTypesGenApp {
   private static String source_dir;
   private static String package_name;
   private static String blib_xml;

   private static void welcome() {
      AppUtils.makeWelcome("BlockTypes Class Generator");
   }

   private static void usage() {
      System.out.println("Usage: btgen -d <source directory>"
         + " -p <package name> <block library>.xml");
      System.exit(-1);
   }

   private static void parseArgs(String[] args) {
      try {
         for(int index = 0; index < args.length; index++) {
            if (args[index].trim().equals("-d")) {
               source_dir = args[++index];
               continue;
            }
            if (args[index].trim().equals("-p")) {
               package_name = args[++index];
               continue;
            }
            blib_xml = args[index];
            if (index != args.length-1) {
               usage();
            }
         }
         if (source_dir == null || package_name == null || blib_xml == null) {
            usage();
         }
      }
      catch(Exception e) {
         usage();
      }
   }

   public static void main(String[] args) throws JAXBException, SAXException {
      parseArgs(args);
      welcome();
      System.out.println("Block library file (xml): " + blib_xml);
      assert source_dir != null && package_name != null & blib_xml != null;
      BlockTypesGen.invoke(source_dir, package_name, blib_xml);
   }
}
