package org.zeyda.clawcircus.utils;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.Data.Diagram.PortDir;

import org.zeyda.clawcircus.Data.ClaSP.BlockWiring;
import org.zeyda.clawcircus.Data.ClaSP.Flow;
import org.zeyda.clawcircus.Data.ClaSP.Enabled;

import org.zeyda.clawcircus.Toolbox.ClaSPLibrary;

import org.zeyda.clawcircus.IO.ClaSP.jaxb.*;

import org.zeyda.clawcircus.collections.*;

import javax.xml.bind.JAXBElement;

import java.util.List;

public class ClaSPUtils {
   private static SignalList generateInps(BlockWiringType block_wiring_type,
      Block block) {
      InpsType inps = block_wiring_type.getInps();
      SignalList result = new SignalListImpl();
      if (inps.isVarlength()) {
         for (Port port : block.getInputPorts()) {
            if (port.isConnected()) {
               result.add(port.getLink().getSignal());
            }
         }
      }
      else {
         int inps_ports_num = MiscUtils.getMaxPosValue(inps.getValue());
         if (block.getInputPortsNum() != inps_ports_num) {
            throw new AssertionError(
               "Inconsistency in number of input ports: "
            +  "ClaSP block library vs. actual inputs of instantiated Block.");
         }
         for (Integer port_num : inps.getValue()) {
            if (block.getInputPort(port_num).isConnected()) {
               result.add(
                  block.getInputPort(port_num).getLink().getSignal());
            }
         }
      }
      return result;
   }

   private static SignalList generateOuts(BlockWiringType block_wiring_type,
      Block block) {
      OutsType outs = block_wiring_type.getOuts();
      SignalList result = new SignalListImpl();
      if (outs.isVarlength()) {
         for (Port port : block.getOutputPorts()) {
            if (port.isConnected()) {
               result.add(port.getLink().getSignal());
            }
         }
      }
      else {
         int outs_ports_num = MiscUtils.getMaxPosValue(outs.getValue());
         if (block.getOutputPortsNum() != outs_ports_num) {
            throw new AssertionError(
               "Inconsistency in number of outpots ports: "
            +  "ClaSP block library vs. actual outputs of instantiated Block.");
         }
         for (Integer port_num : outs.getValue()) {
            if (block.getOutputPort(port_num).isConnected()) {
               result.add(
                  block.getOutputPort(port_num).getLink().getSignal());
            }
         }
      }
      return result;
   }
}
