package org.zeyda.clawcircus.Toolbox;

import org.zeyda.clawcircus.Data.ClaSP.BlockWiring;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.PortDir;

import org.zeyda.clawcircus.utils.FileUtils;
import org.zeyda.clawcircus.utils.TransUtils;
import org.zeyda.clawcircus.utils.LatexUtils;

import org.zeyda.clawcircus.collections.*;
import org.zeyda.clawcircus.collections.impl.*;

import org.zeyda.clawcircus.resources.Resources;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.z.ast.Spec;

import net.sourceforge.czt.parser.circus.ParseUtils;
import net.sourceforge.czt.print.circus.PrintUtils;

import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.session.Source;
import net.sourceforge.czt.session.StringSource;

/* ... */
import net.sourceforge.czt.print.util.LatexString;

import net.sourceforge.czt.session.Key;
import net.sourceforge.czt.session.FileSource;

import org.antlr.stringtemplate.StringTemplate;

import java.io.PrintWriter;
import java.io.StringWriter;

public class CircusTranslator {
   public static @SuppressWarnings("unchecked") void invoke(Block block) {
      SectionManager sect_man = createSectionManager();
      try {
         StringTemplate circus_proc_st = toCircusProcess(block);
         StringTemplate latex_wrapper_st =
            Resources.WRAPPERS_STG.getInstanceOf("latex_wrapper");

         latex_wrapper_st.setAttribute("content", circus_proc_st);

         String latex_raw = latex_wrapper_st.toString();

         System.out.println(latex_raw);

         FileUtils.writeTextFile("latex/test_raw.tex", latex_raw);

         FileSource source = new FileSource("latex/test_raw.tex");
         sect_man.put(new Key(source.getName(), Source.class), source);

         Spec spec = (Spec)
            sect_man.get(new Key(source.getName(), Spec.class));

         LatexString latex_czt = (LatexString)
            sect_man.get(new Key(source.getName(), LatexString.class));

         FileUtils.writeTextFile(
            "latex/test_czt.tex", latex_czt.toString());
      }
      /*try {
         StringTemplate circus_proc_st = toCircusProcess(block);

         StringTemplate latex_wrapper_st =
            Resources.WRAPPERS_STG.getInstanceOf("latex_wrapper");

         latex_wrapper_st.setAttribute("content", circus_proc_st);

         String latex_raw = latex_wrapper_st.toString();

         System.out.println(latex_raw);

         FileUtils.writeTextFile("latex/test_raw.tex", latex_raw);

         Term circus_proc = ParseUtils.parse(
            new StringSource(circus_proc_st.toString()), sect_man);

         StringWriter latex_czt = new StringWriter();
         PrintWriter writer = new PrintWriter(latex_czt);
         PrintUtils.printLatex(circus_proc, writer, sect_man);
         writer.flush();

         StringTemplate ltcadiz_wrapper_st =
            Resources.WRAPPERS_STG.getInstanceOf("ltcadiz_wrapper");

         ltcadiz_wrapper_st.setAttribute("content", latex_czt.toString());

         FileUtils.writeTextFile(
            "latex/test_czt.tex", ltcadiz_wrapper_st.toString());
      }*/
      catch(Exception e) {
         System.out.println(e);
         System.exit(-1);
      }
   }

   public static StringTemplate toCircusProcess(Block block) {
      return toCircusProcess(block, false);
   }

   public static StringTemplate toCircusProcess(Block block,
      boolean simplify) {
      boolean is_state = !TransUtils.getState(block).isEmpty();
      BlockWiring block_wiring = block.getBlockWiring();
      StringTemplate circus_process_st = getTemplate("circus_process");
      circus_process_st.setAttribute(
         "clawz_name", LatexUtils.encode(block.getClawZName()));
      circus_process_st.setAttribute(
         "block_name", LatexUtils.encode(block.getName()));
      circus_process_st.setAttribute("inputs",
         SignalInfoBridge.createList(
            block_wiring.getInps(), block, PortDir.INPUT));
      circus_process_st.setAttribute("outputs",
         SignalInfoBridge.createList(
            block_wiring.getOuts(), block, PortDir.OUTPUT));
      circus_process_st.setAttribute(
         "state", StateInfoBridge.createList(block));
      circus_process_st.setAttribute(
         "flows", FlowBridge.createList(block_wiring, block));
      circus_process_st.setAttribute(
         "simplify", simplify && !is_state);
      setClawZOutput(circus_process_st, block);
      return circus_process_st;
   }

   private static void setClawZOutput(StringTemplate circus_proc_st,
      Block block) {
      /* Not yet implemented. */
   }

   private static SectionManager createSectionManager() {
      SectionManager sect_man = new SectionManager("circus");
      sect_man.setProperty("czt.path", "czt");
      return sect_man;
   }

   private static StringTemplate getTemplate(String name) {
      return Resources.DEFAULT_TRANSLATOR_STG.getInstanceOf(name);
   }
}
