package org.zeyda.clawcircus.utils;

import org.zeyda.clawcircus.Data.Simulink.MdlBlock;

import org.zeyda.clawcircus.exceptions.MdlSemanticException;

/* A bit more should be done here in terms of detailed error reporting. */

public class MdlUtils {
   public static String getStringAttribute(String attr_name, MdlBlock block)
      throws MdlSemanticException {
      String attr_value = block.getAttributeValue(attr_name);
      if (attr_value == null) {
         throw new MdlSemanticException(
            "No " + attr_name + " attribute present.", block);
      }
      if (attr_value.length() >= 2 &&
         attr_value.charAt(0) == '\"' &&
         attr_value.charAt(attr_value.length()-1) == '\"') {
         attr_value = StringUtils.unquote(attr_value);
      }
      return attr_value;
   }

   public static int getIntegerAttribute(String attr_name, MdlBlock block)
      throws MdlSemanticException {
      try {
         return Integer.parseInt(getStringAttribute(attr_name, block));
      }
      catch(NumberFormatException e) {
         throw new MdlSemanticException(
            "Error parsing number in " + attr_name + " attribute.", block);
      }
   }

   public static String filterOpMask(String str) {
      StringBuilder result = new StringBuilder();
      for(int i = 0; i < str.length(); i++) {
         char c = str.charAt(i);
         if (c != '|' && c != ' ' /* ... */) {
            result.append(c);
         }
      }
      return result.toString();
   }
}
