package org.zeyda.clawcircus.UI;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.BlockComparator;

import org.zeyda.clawcircus.collections.*;

import java.util.Collections;
import java.util.Iterator;

import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.EventListenerList;

public class BlockTreeModel implements TreeModel {
   public final static boolean DEFAULT_HIDEPORTS = true;
   protected Block root;
   protected EventListenerList listeners;

   protected boolean hide_ports;

   public BlockTreeModel(Block root) {
      assert root != null;
      this.root = root;
      listeners = new EventListenerList();
      setHidePorts(DEFAULT_HIDEPORTS);
   }

   public boolean getHidePorts() {
      return hide_ports;
   }

   public void setHidePorts(boolean hide_ports) {
      this.hide_ports = hide_ports;
      for(TreeModelListener l :
         listeners.getListeners(TreeModelListener.class)) {
         l.treeStructureChanged(new TreeModelEvent(root, root.getTreePath()));
      }
   }

   /* Implementation of the TreeModel interface. */

   public void addTreeModelListener(TreeModelListener l) {
      listeners.add(TreeModelListener.class, l);
   }

   public Object getChild(Object parent, int index) {
      assert parent instanceof Block;
      BlockList children =
         reorderBlockList(((Block) parent).getChildren());
      return children.get(index);
   }

   public int getChildCount(Object parent) {
      assert parent instanceof Block;
      BlockList children =
         reorderBlockList(((Block) parent).getChildren());
      return children.size();
   }

   public int getIndexOfChild(Object parent, Object child) {
      assert parent instanceof Block;
      BlockList children =
         reorderBlockList(((Block) parent).getChildren());
      return children.indexOf(child);
   }

   public Object getRoot() {
      return root;
   }

   public boolean isLeaf(Object node) {
      assert node instanceof Block;
      return !((Block) node).isSubSystem();
   }

   public void removeTreeModelListener(TreeModelListener l) {
      listeners.remove(TreeModelListener.class, l);
   }

   public void valueForPathChanged(TreePath path, Object newValue) {
      for(TreeModelListener l :
         listeners.getListeners(TreeModelListener.class)) {
         l.treeNodesChanged(new TreeModelEvent(newValue, path));
      }
   }

   /* Utility methods. */

   protected BlockList reorderBlockList(BlockList blocks) {
      BlockList copy = (BlockList) blocks.clone();
      Collections.sort(copy, new BlockComparator());
      if (hide_ports) {
         for(Iterator<Block> iter = copy.iterator(); iter.hasNext(); ) {
            Block block = iter.next();
            if (block.isPort()) {
               iter.remove();
            }
         }
      }
      return copy;
   }
}
