package org.zeyda.clawcircus.Toolbox;

import org.zeyda.clawcircus.Data.ClaSP.BlockWiring;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;
import org.zeyda.clawcircus.Data.Diagram.PortDir;

import org.zeyda.clawcircus.Data.ClaSP.BlockWiringType;

import org.zeyda.clawcircus.Toolbox.st.*;

import org.zeyda.clawcircus.collections.*;
import org.zeyda.clawcircus.collections.impl.*;

import org.zeyda.clawcircus.resources.Resources;

import org.zeyda.clawcircus.utils.DiagramUtils;
import org.zeyda.clawcircus.utils.LatexUtils;
import org.zeyda.clawcircus.utils.TransUtils;

import org.antlr.stringtemplate.StringTemplate;

import java.io.PrintWriter;
import java.io.StringWriter;

public class CircusTranslator {
   public static final String ADJUST_GAPS_VSPACE = "-4ex";

   private static boolean simplify;

   static {
      setSimplify(false);
   }

   public static void setSimplify(boolean flag) {
      CircusTranslator.simplify = flag;
   }

   public static boolean getSimplify() {
      return CircusTranslator.simplify;
   }

   public static String translate(Block block) {
      StringWriter string = new StringWriter();
      PrintWriter writer = new PrintWriter(string);
      translate(block, writer);
      writer.flush();
      String result = string.toString();
      result = postProcessCircusLatex(result);
      result = wrapIntoLatexDocument(block, result);
      return result;
   }

   public static String translateAll(Block block) {
      StringWriter string = new StringWriter();
      PrintWriter writer = new PrintWriter(string);
      translateAll(block, writer);
      writer.flush();
      String result = string.toString();
      result = postProcessCircusLatex(result);
      result = wrapIntoLatexDocument(block, result);
      return result;
   }

   private static void translate(Block block, PrintWriter writer) {
      assert block.getProperty("translatable", Boolean.class);
      makeProcessSection(block, writer);
      /* Create channel declarations for centralised subsystem. */
      if (block.isSubSystem() && ((SubSystem) block).isCentralised()) {
         StringTemplate channel_decl_st = toChannelDeclST((SubSystem) block);
         writer.println();
         writer.println(channel_decl_st.toString());
      }
      /* Create circus process. */
      StringTemplate process_st = toProcessST(block);
      String process_str = process_st.toString();
      if (block.isSubSystem() && ((SubSystem) block).isParallel()) {
         process_str = TransUtils.breakDownNwayParallel(process_str);
      }
      writer.println();
      writer.println(process_str);
   }

   public static void translateAll(Block block, PrintWriter writer) {
      /* Create channel declarations for parallel subsystem. */
      if (block.isSubSystem() && ((SubSystem) block).isParallel()) {
         makeChannelSection(block, writer);
         StringTemplate channel_decl_st = toChannelDeclST((SubSystem) block);
         writer.println();
         writer.println(channel_decl_st.toString());
      }
      /* Declare channel end_cycle. */
      if (block.isRoot()) {
         StringTemplate end_cycle_decl_st = getTemplate("end_cycle_decl");
         writer.println();
         writer.println(end_cycle_decl_st.toString());
      }
      /* For parallel subsystem translate each block recursively. */
      if (block.isSubSystem() && ((SubSystem) block).isParallel()) {
         for(Block child : ((SubSystem) block).getBlocks()) {
            translateAll(child, writer);
         }
      }
      if (block.getProperty("translatable", Boolean.class)) {
         translate(block, writer);
      }
   }

   private static StringTemplate toChannelDeclST(SubSystem subsystem) {
      StringTemplate channel_decls_st = getTemplate("channel_decls");
      SignalSet channels = new SignalSetImpl();
      channels.addAll(
         subsystem.getBlockWiring(BlockWiringType.INNER).getInps());
      channels.addAll(
         subsystem.getBlockWiring(BlockWiringType.INNER).getOuts());
      /* For parallel translation include channels for internal wires. */
      if (subsystem.isParallel()) {
         channels.addAll(DiagramUtils.getInnerLinks(subsystem).toSignalSet());
      }
      channel_decls_st.setAttribute(
         "channels", SignalConnector.createList(channels));
      return channel_decls_st;
   }

   private static StringTemplate toProcessST(Block block) {
      BlockWiring block_wiring = block.getBlockWiring();
      if (block.isSubSystem()) {
         /* For a subsystem we utilise the inner block wiring. */
         block_wiring =
            ((SubSystem) block).getBlockWiring(BlockWiringType.INNER);
      }
      StringTemplate process_st;
      if (block.isPrimitive() ||
         (block.isSubSystem() && ((SubSystem) block).isCentralised())) {
         process_st = getTemplate("process_ctr");
      }
      else {
         assert block.isSubSystem() && ((SubSystem) block).isParallel();
         process_st = getTemplate("process_par");
      }
      process_st.setAttribute(
         "clawz_name", LatexUtils.encode(block.getClawZName()));
      if (process_st.getName().equals("process_ctr")) {
         if (block.isOutport()) {
            process_st.setAttribute(
               "clawz_schema", getTemplate("output_schema"));
         }
         process_st.setAttribute("inputs",
            SignalConnector.createList(
               block_wiring.getInps(), block, PortDir.INPUT));
         process_st.setAttribute("outputs",
            SignalConnector.createList(
               block_wiring.getOuts(), block, PortDir.OUTPUT));
         process_st.setAttribute(
            "state", StateInfoConnector.createList(block));
         process_st.setAttribute(
            "flows", FlowConnector.createList(block_wiring, block));
      }
      else {
         assert process_st.getName().equals("process_par");
         SubSystem subsystem = (SubSystem) block;
         process_st.setAttribute(
            "blocks", BlockConnector.createList(subsystem));
         process_st.setAttribute(
            "inner_signals", SignalConnector.createList(
               DiagramUtils.getInnerLinks(subsystem).toSignalSet()));
      }
      process_st.setAttribute("simplify", simplify);
      return process_st;
   }

   public static String wrapIntoLatexDocument(Block block, String content) {
      StringTemplate latex_wrapper_st =
         Resources.LATEX_STG.getInstanceOf("latex_wrapper");
      latex_wrapper_st.setAttribute(
         "spec_name", LatexUtils.encode(block.getPath().toString()));
      latex_wrapper_st.setAttribute("content", content);
      return latex_wrapper_st.toString();
   }

   private static void makeProcessSection(Block block, PrintWriter writer) {
      /*if (block.isPrimitive()) {
         makeLine(writer);
      }
      else {*/
         StringTemplate process_section_st =
            Resources.LATEX_STG.getInstanceOf("process_section");
         process_section_st.setAttribute(
            "proc_name", LatexUtils.encode(block.getPath().toString()));
         writer.println();
         writer.println(process_section_st.toString());
      /*}*/
   }

   private static void makeChannelSection(Block block, PrintWriter writer) {
      StringTemplate channel_section_st =
         Resources.LATEX_STG.getInstanceOf("channel_section");
      channel_section_st.setAttribute(
         "proc_name", LatexUtils.encode(block.getPath().toString()));
      writer.println();
      writer.println(channel_section_st.toString());
   }

   private static void makeLine(PrintWriter writer) {
      StringTemplate hline_st = Resources.LATEX_STG.getInstanceOf("hline");
      writer.println();
      writer.println(hline_st.toString());
   }

   private static String postProcessCircusLatex(String circus_latex) {
      String result = circus_latex;
      result = TransUtils.removeExplicitNewlines(result);
      result = TransUtils.removeSurplusNewlines(result);
      result = TransUtils.removeSpaceBeforeLatexLineBreaks(result);
      /*result = TransUtils.adjustVerticalGaps(result, ADJUST_GAPS_VSPACE);*/
      return result;
   }

   private static StringTemplate getTemplate(String name) {
      return Resources.CIRCTRANS_STG.getInstanceOf(name);
   }
}
