package org.zeyda.clawcircus.Toolbox;

import org.zeyda.clawcircus.Data.Diagram.BlockUtil;

import org.zeyda.clawcircus.IO.ClaSP.jaxb.*;

import org.zeyda.clawcircus.resources.Resources;

import org.zeyda.clawcircus.utils.FileUtils;
import org.zeyda.clawcircus.utils.MiscUtils;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

import java.io.File;
import java.io.StringWriter;
import java.io.PrintWriter;

public class BlockTypesGen {
   private static final String ROOT_PKG = "org.zeyda.clawcircus";

   public static void invoke(String src_dir, String pkg_name, String clasp_xml)
   {
      ClaSPXml clasp = ClaSPLibrary.getClaSP();
      BlockLibraryXml block_library = clasp.getBlockLibrary();
      for(BlockTypeXml block_type : block_library.getBlockType()) {
         if (block_type.isGenclass()) {
            String cls_name =
               BlockUtil.convBlockTypeToClass(block_type.getName());
            BlockWiringXml block_wiring = block_type.getBlockWiring();
            Integer inps_num = processInpsOuts(block_wiring.getInps());
            Integer outs_num = processInpsOuts(block_wiring.getOuts());
            boolean translatable = block_type.isTranslatable();
            boolean state = block_type.isState();
            StringTemplate blocktypes_st =
               Resources.GEN_STG.getInstanceOf("blocktypes");
            blocktypes_st.setAttribute("pkg_name", pkg_name);
            blocktypes_st.setAttribute("cls_name", cls_name);
            blocktypes_st.setAttribute("base", block_type.getBase());
            if (!cls_name.equals(block_type.getName())) {
               blocktypes_st.setAttribute("block_type", block_type.getName());
            }
            blocktypes_st.setAttribute("inputs", inps_num);
            blocktypes_st.setAttribute("outputs", outs_num);
            blocktypes_st.setAttribute(
               "varlength", inps_num == null || outs_num == null);
            blocktypes_st.setAttribute("translatable", translatable);
            blocktypes_st.setAttribute("state", state);
            String file_path = makeOutputPath(src_dir, pkg_name, cls_name);
            System.out.println("writing " + file_path);
            FileUtils.writeTextFile(file_path, blocktypes_st.toString());
         }
      }
   }

   private static Integer processInpsOuts(String inps_outs) {
      Integer inps_outs_num;
      if (inps_outs != null) {
         inps_outs = inps_outs.trim().toLowerCase();
         assert inps_outs.equals("varlength") ||
            MiscUtils.canBeParsedAsInt(inps_outs);
         if (!inps_outs.equals("varlength")) {
            inps_outs_num = Integer.parseInt(inps_outs);
         }
         else {
            inps_outs_num = null;
         }
      }
      else {
         inps_outs_num = 0;
      }
      return inps_outs_num;
   }

   private static String makeOutputPath(String src_dir, String pkg_name,
      String name) {
      src_dir = src_dir.trim();
      /* Remove separator (if present) from the end of src_dir. */
      if (src_dir.endsWith(File.separator) && !src_dir.equals(File.separator)) {
         src_dir =
            src_dir.substring(0, src_dir.length() - File.separator.length());
      }
      return src_dir + File.separator + pkg_name.replace(".", File.separator)
         + File.separator + name + ".java";
   }
}
