package org.zeyda.clawcircus.IO;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

import java.util.List;
import java.util.ArrayList;

public class RedirectThread extends Thread {
   protected InputStream from;
   protected OutputStream to;
   protected boolean silent;
   protected List<Integer> buffer;

   public RedirectThread(InputStream from, OutputStream to, boolean silent) {
      assert from != null;
      assert to != null;
      this.from = from;
      this.to = to;
      this.silent = silent;
      buffer = new ArrayList<Integer>();
   }

   public RedirectThread(InputStream from, OutputStream to) {
      this(from, to, false);
   }

   public RedirectThread(InputStream from, boolean silent) {
      this(from, System.out, silent);
   }

   public RedirectThread(InputStream from) {
      this(from, false);
   }

   public void run() {
      try {
         for(int data = from.read(); data != -1; data = from.read()) {
            if (silent) {
               buffer.add(data);
            }
            else {
               to.write(data);
            }
         }
         to.flush();
      }
      catch(IOException e) {
      }
   }

   public void flush() {
      try {
         for(int data : buffer) {
            to.write(data);
         }
      }
      catch(IOException e) {
      }
      buffer.clear();
   }

   public static RedirectThread create(InputStream from, OutputStream to) {
      RedirectThread thread = new RedirectThread(from, to);
      thread.start();
      return thread;
   }

   public static RedirectThread create(InputStream from, OutputStream to,
      boolean silent) {
      RedirectThread thread = new RedirectThread(from, to, silent);
      thread.start();
      return thread;
   }

   public static RedirectThread create(InputStream from) {
      RedirectThread thread = new RedirectThread(from);
      thread.start();
      return thread;
   }

   public static RedirectThread create(InputStream from, boolean silent) {
      RedirectThread thread = new RedirectThread(from, silent);
      thread.start();
      return thread;
   }
}
