package org.zeyda.clawcircus.Data.Diagram.BlockTypes.custom;

import org.zeyda.clawcircus.Data.Simulink.MdlBlock;

import org.zeyda.clawcircus.Data.ClaSP.BlockWiring;
import org.zeyda.clawcircus.Data.ClaSP.Enabled;
import org.zeyda.clawcircus.Data.ClaSP.Flow;

import org.zeyda.clawcircus.utils.MdlUtils;

import org.zeyda.clawcircus.collections.*;
import org.zeyda.clawcircus.collections.impl.*;

import org.zeyda.clawcircus.exceptions.MdlSemanticException;

public class Outport extends
   org.zeyda.clawcircus.Data.Diagram.BlockTypes.gen.Outport {
   protected int port_num;

   public @Override int getPortNum() {
      return port_num;
   }

   public void setPortNum(int port_num) {
      if (!(port_num >= 1)) {
         throw new IllegalArgumentException(
            "Port number must be a positive integer.");
      }
      this.port_num = port_num;
   }

   public @Override void initialise() throws MdlSemanticException {
      super.initialise();
      if (hasAnnotation(MdlBlock.class)) {
         MdlBlock mdl_block = getAnnotation(MdlBlock.class);
         setPortNum(MdlUtils.getIntegerAttribute("Port", mdl_block));
      }
   }

   public @Override BlockWiring calcBlockWiring() {
      SignalList inps = new SignalListImpl();
      SignalList outs = new SignalListImpl();
      inps.add(getUniqueLink().getSignal());
      outs.add(getSignal());
      FlowSet flows = new FlowSetImpl();
      SignalSet rinps = new SignalSetImpl();
      SignalSet pouts = new SignalSetImpl();
      rinps.addAll(inps);
      pouts.addAll(outs);
      flows.add(new Flow(Enabled.ALWAYS, false, rinps, pouts));
      return new BlockWiring(inps, outs, flows);
   }
}
