package org.zeyda.clawcircus.Data.Diagram.BlockTypes.custom;

import org.zeyda.clawcircus.Data.Diagram.Link;

import org.zeyda.clawcircus.Data.Simulink.MdlBlock;

import org.zeyda.clawcircus.utils.MdlUtils;

import org.zeyda.clawcircus.exceptions.MdlSemanticException;

public class Inport extends
   org.zeyda.clawcircus.Data.Diagram.BlockTypes.gen.Inport {
   protected int port_num;

   public @Override int getPortNum() {
      return port_num;
   }

   public void setPortNum(int port_num) {
      if (!(port_num >= 1)) {
         throw new IllegalArgumentException(
            "Port number must be a positive integer.");
      }
      this.port_num = port_num;
   }

   public @Override void initialise() throws MdlSemanticException {
      super.initialise();
      if (hasAnnotation(MdlBlock.class)) {
         MdlBlock mdl_block = getAnnotation(MdlBlock.class);
         setPortNum(MdlUtils.getIntegerAttribute("Port", mdl_block));
      }
   }
}
