package org.zeyda.clawcircus.Application;

import org.zeyda.clawcircus.ProofPower.*;

import org.zeyda.clawcircus.utils.AppUtils;
import org.zeyda.clawcircus.utils.FileUtils;

public class PPTheoremManagerApp {
   private static void welcome() {
      AppUtils.makeWelcome("ProofPower Theorem Manager");
   }

   private static void usage() {
      System.out.println("Usage: ppthman <input file>.doc");
      System.exit(-1);
   }

   public static void main(String[] args) {
      if (args.length != 1) {
         usage();
      }
      welcome();
      System.out.println("Reading from input file: " + args[0]);
      String text = FileUtils.readTextFile(args[0]);
      System.out.println("Parsing SML...");
      DocParser.parseDoc(text);
   }
}
