/*
 * ProcessTypeImpl.java
 *
 * Created on 6 de Julho de 2005, 13:49
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package net.sourceforge.czt.typecheck.circus.impl;

import net.sourceforge.czt.circustools.ast.*;
import net.sourceforge.czt.circustools.visitor.*;
import net.sourceforge.czt.typecheck.z.impl.*;

/**
 *
 * @author Manuela
 */
public class ProcessTypeImpl
  extends Type2Impl
  implements ProcessType
{
  
  /** Creates a new instance of ProcessTypeImpl */
  protected ProcessTypeImpl(ProcessType processType)
  {
    super(processType);
  }
  
  public ProcessSignature getProcessSignature() 
  {
    ProcessType processType = (ProcessType) term_;
    ProcessSignature result = processType.getProcessSignature();
    return result;
  }

  public void setProcessSignature(ProcessSignature processSignature)
  {
    ProcessType processType = (ProcessType) term_;
    processType.setProcessSignature(processSignature);
  }
  
  public boolean equals(Object obj)
  {
    if (obj instanceof ProcessType) {
      ProcessType processType = (ProcessType) obj;
      return getProcessSignature().equals(processType.getProcessSignature());
    }
    return false;
  }

  public int hashCode()
  {
    final int constant = 31;

    int hashCode = super.hashCode();
    hashCode += "ProcessTypeImpl".hashCode();
    if (getProcessSignature() != null) {
      //hashCode += constant * getProcessSignature().hashCode();
    }
    return hashCode;
  }

  /**
   * Accepts a visitor.
   */
  public Object accept(net.sourceforge.czt.util.Visitor v)
  {
    if (v instanceof ProcessTypeVisitor) {
      ProcessTypeVisitor visitor = (ProcessTypeVisitor) v;
      return visitor.visitProcessType(this);
    }
    return super.accept(v);
  }

  public net.sourceforge.czt.base.ast.Term create(Object [] args)
  {
    ProcessType processType = (ProcessType) term_.create(args);
    ProcessType result = new ProcessTypeImpl(processType);
    return result;
  }

}
