/*
 * ActionTypeImpl.java
 *
 * Created on 6 de Julho de 2005, 15:13
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package net.sourceforge.czt.typecheck.circus.impl;

import net.sourceforge.czt.circustools.ast.*;
import net.sourceforge.czt.circustools.visitor.*;
import net.sourceforge.czt.typecheck.z.impl.*;

/**
 *
 * @author Manuela
 */
public class ActionTypeImpl
  extends Type2Impl
  implements ActionType
{
  
  /** Creates a new instance of ActionTypeImpl */
  protected ActionTypeImpl(ActionType actionType)
  {
    super(actionType);
  }
  
  public ActionSignature getActionSignature() 
  {
    ActionType actionType = (ActionType) term_;
    ActionSignature result = actionType.getActionSignature();
    return result;
  }

  public void setActionSignature(ActionSignature actionSignature)
  {
    ActionType actionType = (ActionType) term_;
    actionType.setActionSignature(actionSignature);
  }
  
  public boolean equals(Object obj)
  {
    if (obj instanceof ActionType) {
      ActionType actionType = (ActionType) obj;
      return getActionSignature().equals(actionType.getActionSignature());
    }
    return false;
  }

  public int hashCode()
  {
    final int constant = 31;

    int hashCode = super.hashCode();
    hashCode += "ActionTypeImpl".hashCode();
    if (getActionSignature() != null) {
      //hashCode += constant * getActionSignature().hashCode();
    }
    return hashCode;
  }

  /**
   * Accepts a visitor.
   */
  public Object accept(net.sourceforge.czt.util.Visitor v)
  {
    if (v instanceof ActionTypeVisitor) {
      ActionTypeVisitor visitor = (ActionTypeVisitor) v;
      return visitor.visitActionType(this);
    }
    return super.accept(v);
  }
  
  public net.sourceforge.czt.base.ast.Term create(Object [] args)
  {
    ActionType actionType = (ActionType) term_.create(args);
    ActionType result = new ActionTypeImpl(actionType);
    return result;
  }
  
}
