/*
 * ProcessType.java
 *
 * Created on 6 de Julho de 2005, 14:34
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package net.sourceforge.czt.typecheck.circus.impl;

import java.util.ArrayList;
import java.util.List;
import static net.sourceforge.czt.typecheck.circus.util.GlobalDefs.*;

import net.sourceforge.czt.typecheck.circus.util.KindOfProcess;
import net.sourceforge.czt.z.ast.*;

/**
 *
 * @author Manuela
 */
public class ProcessInfo
{
  
  private DeclName processName_;
  
  private KindOfProcess kindOfProcess_;
  
  private boolean isGeneric_;
  
  private List<DeclName> genParams_;
  
  private List<NameTypePair> usedChans_;
  
  private List<NameTypePair> paramsOrIndexes_;

//<<03/11/2005>>
  private List<NameTypePair> localVars_;
//
  
  /** Creates a new instance of ProcessType */
  public ProcessInfo(DeclName procName)
  {
    processName_ = procName;
    kindOfProcess_ = KindOfProcess.NORMAL;
    isGeneric_ = false;
    genParams_ = null;
    usedChans_ = null;
    paramsOrIndexes_ = null;
    localVars_ = new ArrayList();
  }
/*
  public ProcessInfo(DeclName procName, List<NameTypePair> usedChans)
  {
    processName_ = procName;
    kindOfProcess_ = KindOfProcess.NORMAL;
    isGeneric_ = false;
    genParams_ = null;
    usedChans_ = usedChans;
    paramsOrIndexes_ = null;
  }
*/
  public ProcessInfo(DeclName procName, boolean isGeneric, List<DeclName> params)
  {
    processName_ = procName;
    kindOfProcess_ = KindOfProcess.NORMAL;
    isGeneric_ = isGeneric;
    genParams_ = params;
    usedChans_ = null;
    paramsOrIndexes_ = null;
    localVars_ = new ArrayList();
  }
/*
  public ProcessInfo(DeclName procName, KindOfProcess kind, boolean isGeneric, List<DeclName> params, List<NameTypePair> usedChans)
  {
    processName_ = procName;
    kindOfProcess_ = kind;
    isGeneric_ = isGeneric;
    genParams_ = params;
    usedChans_ = usedChans;
    paramsOrIndexes_ = null;
  }
*/
  public DeclName getProcessName()
  {
    return processName_;
  }
  
  public void setProcessName(DeclName processName)
  {
    processName_ = processName;
  }
  
  public KindOfProcess getKindOfProcess()
  {
    return kindOfProcess_;
  }
  
  public void setKindOfProcess(KindOfProcess kind) 
  {
    kindOfProcess_ = kind;
  }
  
  public List<DeclName> getGenParams() 
  {
    return genParams_;
  }
  
  public void setGenParams(List<DeclName> params)
  {
    genParams_ = params;
  }
  
  public boolean isGeneric() 
  {
    return isGeneric_;
  }
  
  public void setIsGeneric(boolean isGeneric)
  {
    isGeneric_ = isGeneric;
  }
  
  public List<NameTypePair> getUsedChans() 
  {
    return usedChans_;
  }
  
  public void setUsedChans(List<NameTypePair> usedChans)
  {
    usedChans_ = usedChans;
  }
  
  public List<NameTypePair> getParamsOrIndexes() {
    return paramsOrIndexes_;
  }
  
  public void setParamsOrIndexes(List<NameTypePair> params) {
    paramsOrIndexes_ = params;
  }
  
//<<03/11/2005>>  
  public List<NameTypePair> getLocalVars() {
    return localVars_;
  }
  
  public boolean isLocalVar(DeclName name) {
    boolean result = false;
    for (NameTypePair local : localVars_) {
      if (local.getName().equals(name)) {
        result = true;
      } 
    }
        
    return result;
  }
  
  public boolean addLocalVar(NameTypePair pair) {
    boolean result = true;
    DeclName name = pair.getName();
    for (NameTypePair local : localVars_) {
      if (local.getName().equals(name)) {
        result = false;
      } 
    }

    if(result) {
      localVars_.add(pair);
    }
        
    return result;
  }
//
}
