/*
 * ProcessAnnImpl.java
 *
 * Created on 6 de Julho de 2005, 20:19
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package net.sourceforge.czt.typecheck.circus.impl;

import net.sourceforge.czt.circustools.ast.ProcessAnn;
import net.sourceforge.czt.circustools.ast.ProcessSignature;
import net.sourceforge.czt.circustools.visitor.ProcessAnnVisitor;
import net.sourceforge.czt.typecheck.z.impl.TermImpl;


/**
 *
 * @author Manuela
 */
public class ProcessAnnImpl
  extends TermImpl
  implements ProcessAnn
{
  
  protected ProcessAnnImpl(ProcessAnn processAnn)
  {
    super(processAnn);
  }

  public void setProcessSignature(ProcessSignature signature)
  {
    ProcessAnn processAnn = (ProcessAnn) term_;
    processAnn.setProcessSignature(signature);
  }

  public ProcessSignature getProcessSignature()
  {
    ProcessAnn processAnn = (ProcessAnn) term_;
    ProcessSignature result = processAnn.getProcessSignature();
    return result;
  }

  public net.sourceforge.czt.base.ast.Term create(Object [] args)
  {
    ProcessAnn processAnn = (ProcessAnn) term_.create(args);
    ProcessAnn result = new ProcessAnnImpl(processAnn);
    return result;
  }

  /**
   * Accepts a visitor.
   */
  public Object accept(net.sourceforge.czt.util.Visitor v)
  {
    if (v instanceof ProcessAnnVisitor) {
      ProcessAnnVisitor visitor = (ProcessAnnVisitor) v;
      return visitor.visitProcessAnn(this);
    }
    return super.accept(v);
  }

  public boolean equals(Object obj)
  {
    if (obj instanceof ProcessAnn) {
      ProcessAnn processAnn = (ProcessAnn) obj;
      return getProcessSignature().equals(processAnn.getProcessSignature());
    }
    return false;
  }

  public int hashCode()
  {
    final int constant = 31;

    int hashCode = super.hashCode();
    hashCode += "ProcessAnnImpl".hashCode();
    if (getProcessSignature() != null) {
      hashCode += constant * getProcessSignature().hashCode();
    }
    return hashCode;
  }
}
