/*
 * Factory.java
 *
 * Created on 17 de Junho de 2005, 17:28
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package net.sourceforge.czt.typecheck.circus.impl;

import net.sourceforge.czt.base.ast.*;
import net.sourceforge.czt.circus.ast.*;
import net.sourceforge.czt.circustools.ast.*;
import net.sourceforge.czt.circustools.impl.*;
import net.sourceforge.czt.z.ast.*;
import net.sourceforge.czt.typecheck.z.impl.*;

/**
 *
 * @author Manuela
 */
public class Factory 
  extends net.sourceforge.czt.typecheck.z.impl.Factory
{
  /** The CircusToolsFactory that is used to create wrapped types. */
  protected CircusToolsFactory circusFactory_;

  public Factory()
  {
    zFactory_ = new net.sourceforge.czt.z.impl.ZFactoryImpl();
    circusFactory_ = new CircusToolsFactoryImpl();
  }

  public Factory(ZFactory zFactory)
  {
    zFactory_ = zFactory;
    circusFactory_ = new CircusToolsFactoryImpl();
  }

  public Factory(ZFactory zFactory, CircusToolsFactory circusFactory)
  {
    zFactory_ = zFactory;
    circusFactory_ = circusFactory;
  }

  public CircusToolsFactory getCircusFactory()
  {
    return circusFactory_;
  }

  public RefChannelSet createRefChannelSet(RefName refName)
  {
    RefChannelSet refChanneType = circusFactory_.createRefChannelSet(refName);
    return refChanneType;
  }

  public BasicChannelSet createBasicChannelSet(ListTerm expr)
  {
    BasicChannelSet basicChannelSetType = circusFactory_.createBasicChannelSet(expr);
    return basicChannelSetType;
  }
 
  public ApplChannelSet createApplChannelSet(Expr expr)
  {
    ApplChannelSet applChannelSetType = circusFactory_.createApplChannelSet(expr);
    return applChannelSetType;
  }

  public RefNameSet createRefNameSet(RefName refName)
  {
    RefNameSet refNameType = circusFactory_.createRefNameSet(refName);
    return refNameType;
  }

  public BasicNameSet createBasicNameSet(ListTerm expr)
  {
    BasicNameSet basicNameSetType = circusFactory_.createBasicNameSet(expr);
    return basicNameSetType;
  }
 
  public ApplNameSet createApplNameSet(Expr expr)
  {
    ApplNameSet applNameSetType = circusFactory_.createApplNameSet(expr);
    return applNameSetType;
  }

  public ProcessSignature createProcessSignature()
  {
    return circusFactory_.createProcessSignature();
  }
  
  public BasicProcessSignature createBasicProcessSignature()
  {
    return circusFactory_.createBasicProcessSignature();
  }

  public ProcessType createProcessType()
  {
    ProcessType processType = circusFactory_.createProcessType();
    ProcessSignature procSig = circusFactory_.createProcessSignature();
    processType.setProcessSignature(procSig);
    ProcessType result = new net.sourceforge.czt.typecheck.circus.impl.ProcessTypeImpl(processType);
    return result;
  }

  public ProcessType createProcessType(ProcessSignature procSig)
  {
    ProcessType processType = circusFactory_.createProcessType(procSig);
    ProcessType result = new ProcessTypeImpl(processType);
    return result;
  }
  
  public ActionSignature createActionSignature()
  {
    return circusFactory_.createActionSignature();
  }
  
  public ActionType createActionType()
  {
    ActionType actionType = circusFactory_.createActionType();
    ActionSignature actionSig = circusFactory_.createActionSignature();
    actionType.setActionSignature(actionSig);
    ActionType result = new ActionTypeImpl(actionType);
    return result;
  }

  public ActionType createActionType(ActionSignature actionSig)
  {
    ActionType actionType = circusFactory_.createActionType(actionSig);
    ActionType result = new ActionTypeImpl(actionType);
    return result;
  }

  public ChanSetType createChanSetType()
  {
    ChanSetType chanSetType = circusFactory_.createChanSetType();
    Signature channelsSig = circusFactory_.createSignature();
    chanSetType.setChannels(channelsSig);
    ChanSetType result = new ChanSetTypeImpl(chanSetType);
    return result;
  }

  public ChanSetType createChanSetType(Signature channelsSig)
  {
    ChanSetType chanSetType = circusFactory_.createChanSetType(channelsSig);
    ChanSetType result = new ChanSetTypeImpl(chanSetType);
    return result;
  }

  public NameSetType createNameSetType()
  {
    NameSetType nameSetType = circusFactory_.createNameSetType();
    Signature namesSig = circusFactory_.createSignature();
    nameSetType.setNames(namesSig);
    NameSetType result = new NameSetTypeImpl(nameSetType);
    return result;
  }

  public NameSetType createNameSetType(Signature namesSig)
  {
    NameSetType nameSetType = circusFactory_.createNameSetType(namesSig);
    NameSetType result = new NameSetTypeImpl(nameSetType);
    return result;
  }

  public ProcessAnn createProcessAnn(ProcessSignature signature)
  {
    ProcessAnn processAnn = circusFactory_.createProcessAnn(signature);
    ProcessAnn result = new ProcessAnnImpl(processAnn);
    return result;
  }

  public ActionAnn createActionAnn(ActionSignature signature)
  {
    ActionAnn actionAnn = circusFactory_.createActionAnn(signature);
    ActionAnn result = new ActionAnnImpl(actionAnn);
    return result;
  }
  
  public SchExprAction createSchExprAction(Expr expr) 
  {
    return circusFactory_.createSchExprAction(expr);
  }
}
